/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

public class TablePermsDescriptor
extends PermissionsDescriptor {
    private UUID tableUUID;
    private String tableName;
    private String selectPriv;
    private String deletePriv;
    private String insertPriv;
    private String updatePriv;
    private String referencesPriv;
    private String triggerPriv;

    public TablePermsDescriptor(DataDictionary dd, String grantee, String grantor, UUID tableUUID, String selectPriv, String deletePriv, String insertPriv, String updatePriv, String referencesPriv, String triggerPriv) throws StandardException {
        super(dd, grantee, grantor);
        this.tableUUID = tableUUID;
        this.selectPriv = selectPriv;
        this.deletePriv = deletePriv;
        this.insertPriv = insertPriv;
        this.updatePriv = updatePriv;
        this.referencesPriv = referencesPriv;
        this.triggerPriv = triggerPriv;
        if (tableUUID != null) {
            this.tableName = dd.getTableDescriptor(tableUUID).getName();
        }
    }

    public TablePermsDescriptor(DataDictionary dd, String grantee, String grantor, UUID tableUUID) throws StandardException {
        this(dd, grantee, grantor, tableUUID, null, null, null, null, null, null);
    }

    public TablePermsDescriptor(DataDictionary dd, UUID tablePermsUUID) throws StandardException {
        this(dd, null, null, null, null, null, null, null, null, null);
        this.oid = tablePermsUUID;
    }

    @Override
    public int getCatalogNumber() {
        return 16;
    }

    public UUID getTableUUID() {
        return this.tableUUID;
    }

    public String getSelectPriv() {
        return this.selectPriv;
    }

    public String getDeletePriv() {
        return this.deletePriv;
    }

    public String getInsertPriv() {
        return this.insertPriv;
    }

    public String getUpdatePriv() {
        return this.updatePriv;
    }

    public String getReferencesPriv() {
        return this.referencesPriv;
    }

    public String getTriggerPriv() {
        return this.triggerPriv;
    }

    public String toString() {
        return "tablePerms: grantee=" + this.getGrantee() + ",tablePermsUUID=" + this.getUUID() + ",grantor=" + this.getGrantor() + ",tableUUID=" + this.getTableUUID() + ",selectPriv=" + this.getSelectPriv() + ",deletePriv=" + this.getDeletePriv() + ",insertPriv=" + this.getInsertPriv() + ",updatePriv=" + this.getUpdatePriv() + ",referencesPriv=" + this.getReferencesPriv() + ",triggerPriv=" + this.getTriggerPriv();
    }

    public boolean equals(Object other) {
        if (!(other instanceof TablePermsDescriptor)) {
            return false;
        }
        TablePermsDescriptor otherTablePerms = (TablePermsDescriptor)other;
        return super.keyEquals(otherTablePerms) && this.tableUUID.equals(otherTablePerms.tableUUID);
    }

    public int hashCode() {
        return super.keyHashCode() + this.tableUUID.hashCode();
    }

    @Override
    public boolean checkOwner(String authorizationId) throws StandardException {
        TableDescriptor td = this.getDataDictionary().getTableDescriptor(this.tableUUID);
        return td.getSchemaDescriptor().getAuthorizationId().equals(authorizationId);
    }

    @Override
    public String getObjectName() {
        return "Table Privilege on " + this.tableName;
    }

    @Override
    public String getClassType() {
        return "TablePrivilege";
    }

    @Override
    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(462);
    }
}

