/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBinary;
import org.apache.derby.iapi.util.StringUtil;

public class SQLBit
extends SQLBinary {
    @Override
    public Object getObject() throws StandardException {
        return this.getBytes();
    }

    @Override
    public String getTypeName() {
        return "CHAR () FOR BIT DATA";
    }

    @Override
    int getMaxMemoryUsage() {
        return 254;
    }

    @Override
    public int getTypeFormatId() {
        return 87;
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLBit();
    }

    @Override
    public final void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException {
        this.setValue(resultSet.getBytes(colNumber));
    }

    @Override
    public int typePrecedence() {
        return 140;
    }

    @Override
    final void setObject(Object theValue) throws StandardException {
        this.setValue((byte[])theValue);
    }

    public SQLBit() {
    }

    public SQLBit(byte[] val) {
        this.dataValue = val;
    }

    @Override
    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        int desiredWidth = desiredType.getMaximumWidth();
        this.setValue(source.getBytes());
        this.setWidth(desiredWidth, 0, true);
    }

    @Override
    public void setWidth(int desiredWidth, int desiredScale, boolean errorOnTrunc) throws StandardException {
        if (this.getValue() == null) {
            return;
        }
        int sourceWidth = this.dataValue.length;
        if (sourceWidth < desiredWidth) {
            byte[] actualData = new byte[desiredWidth];
            System.arraycopy(this.dataValue, 0, actualData, 0, this.dataValue.length);
            Arrays.fill(actualData, this.dataValue.length, actualData.length, (byte)32);
            this.dataValue = actualData;
        } else if (sourceWidth > desiredWidth) {
            if (errorOnTrunc) {
                for (int i = desiredWidth; i < this.dataValue.length; ++i) {
                    if (this.dataValue[i] == 32) continue;
                    throw StandardException.newException("22001", this.getTypeName(), StringUtil.formatForPrint(this.toString()), String.valueOf(desiredWidth));
                }
            }
            this.truncate(sourceWidth, desiredWidth, !errorOnTrunc);
        }
    }
}

