/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;

class DropViewNode
extends DDLStatementNode {
    DropViewNode(TableName view, ContextManager cm) {
        super(view, cm);
    }

    @Override
    String statementToString() {
        return "DROP VIEW";
    }

    @Override
    public void bindStatement() throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        CompilerContext cc = this.getCompilerContext();
        TableDescriptor td = dd.getTableDescriptor(this.getRelativeName(), this.getSchemaDescriptor(), this.getLanguageConnectionContext().getTransactionCompile());
        if (td != null) {
            cc.createDependency(td);
        }
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropViewConstantAction(this.getFullName(), this.getRelativeName(), this.getSchemaDescriptor());
    }
}

