/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.StaticMethodCallNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

class JavaToSQLValueNode
extends ValueNode {
    JavaValueNode javaNode;

    JavaToSQLValueNode(JavaValueNode value, ContextManager cm) {
        super(cm);
        this.javaNode = value;
    }

    @Override
    ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        this.javaNode.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        return this;
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.javaNode.returnValueToSQLDomain();
        boolean hasReceiver = this.javaNode.generateReceiver(acb, mb);
        if (hasReceiver) {
            String nullValueClass = this.getTypeCompiler().interfaceName();
            LocalField nullValueField = acb.newFieldDeclaration(2, nullValueClass);
            mb.conditionalIfNull();
            mb.getField(nullValueField);
            acb.generateNullWithExpress(mb, this.getTypeCompiler(), this.getTypeServices().getCollationType());
            mb.startElseCode();
        }
        TypeId resultType = this.getTypeId();
        TypeCompiler tc = this.getTypeCompiler();
        String resultTypeName = tc.interfaceName();
        LocalField field = acb.newFieldDeclaration(2, resultTypeName);
        this.javaNode.generateExpression(acb, mb);
        acb.generateDataValue(mb, tc, this.getTypeServices().getCollationType(), field);
        if (hasReceiver) {
            mb.completeConditional();
        }
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        this.printLabel(depth, "javaNode: ");
        this.javaNode.treePrint(depth + 1);
    }

    JavaValueNode getJavaValueNode() {
        return this.javaNode;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        AggregateNode agg;
        this.javaNode.checkReliability(this);
        this.javaNode = this.javaNode.bindExpression(fromList, subqueryList, aggregates);
        if (this.javaNode instanceof StaticMethodCallNode && (agg = ((StaticMethodCallNode)this.javaNode).getResolvedAggregate()) != null) {
            return agg.bindExpression(fromList, subqueryList, aggregates);
        }
        DataTypeDescriptor dts = this.javaNode.getDataType();
        if (dts == null) {
            throw StandardException.newException("X0X57.S", this.javaNode.getJavaTypeName());
        }
        TypeDescriptor catalogType = dts.getCatalogType();
        if (catalogType.isRowMultiSet() || catalogType.getTypeName().equals("java.sql.ResultSet")) {
            throw StandardException.newException("42ZB6", new Object[0]);
        }
        this.setType(dts);
        if (dts.getTypeId().isStringTypeId()) {
            this.setCollationInfo(this.javaNode.getCollationType(), 1);
        }
        return this;
    }

    @Override
    ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.javaNode = this.javaNode.remapColumnReferencesToExpressions();
        return this;
    }

    @Override
    boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        return this.javaNode.categorize(referencedTabs, simplePredsOnly);
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        return this.javaNode.getOrderableVariantType();
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.javaNode != null) {
            this.javaNode = (JavaValueNode)this.javaNode.accept(v);
        }
    }

    @Override
    boolean isEquivalent(ValueNode o) {
        return false;
    }
}

