/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.SURBaseTest;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.SURDataModelSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class HoldabilityTest
extends SURBaseTest {
    private static final String selectStatement = "select * from t1";

    public HoldabilityTest(String name) {
        super(name, 1000);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(HoldabilityTest.class);
    }

    protected void setUp() throws Exception {
        SURDataModelSetup.createDataModel(SURDataModelSetup.SURDataModel.MODEL_WITH_PK, this.getConnection(), this.recordCount);
        this.commit();
    }

    @Override
    protected void tearDown() throws Exception {
        this.commit();
        super.tearDown();
    }

    public void testHeldForwardOnlyResultSetScanInit() throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery(selectStatement);
        this.commit();
        this.scrollForward(rs);
        s.close();
    }

    public void testHeldForwardOnlyResultSetScanInProgress() throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery(selectStatement);
        for (int i = 0; i < this.recordCount / 2; ++i) {
            rs.next();
            this.verifyTuple(rs);
        }
        this.commit();
        while (rs.next()) {
            this.verifyTuple(rs);
        }
        s.close();
    }

    public void testHeldForwardOnlyUpdatableResultSetScanInit() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        ResultSet rs = s.executeQuery(selectStatement);
        this.commit();
        rs.next();
        this.updateTuple(rs);
        this.scrollForward(rs);
        s.close();
    }

    public void testCompressOnHeldForwardOnlyUpdatableResultSetScanInProgress() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        ResultSet rs = s.executeQuery(selectStatement);
        for (int i = 0; i < this.recordCount / 2; ++i) {
            rs.next();
            this.verifyTuple(rs);
        }
        this.updateTuple(rs);
        this.commit();
        this.verifyResultSetUpdatableAfterCompress(rs);
        s.close();
    }

    public void testCompressOnHeldForwardOnlyUpdatableResultSetScanInit() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        ResultSet rs = s.executeQuery(selectStatement);
        this.commit();
        this.verifyResultSetUpdatableAfterCompress(rs);
        s.close();
    }

    public void testHeldForwardOnlyUpdatableResultSetScanInProgress() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        ResultSet rs = s.executeQuery(selectStatement);
        for (int i = 0; i < this.recordCount / 2; ++i) {
            rs.next();
            this.verifyTuple(rs);
        }
        this.updateTuple(rs);
        this.commit();
        rs.next();
        this.updateTuple(rs);
        while (rs.next()) {
            this.verifyTuple(rs);
        }
        s.close();
    }

    public void testHeldScrollableResultSetScanInit() throws SQLException {
        Statement s = this.createStatement(1004, 1007);
        ResultSet rs = s.executeQuery(selectStatement);
        this.commit();
        this.scrollForward(rs);
        this.scrollBackward(rs);
        s.close();
    }

    public void testHeldScrollableResultSetScanInProgress() throws SQLException {
        Statement s = this.createStatement(1004, 1007);
        ResultSet rs = s.executeQuery(selectStatement);
        for (int i = 0; i < this.recordCount / 2; ++i) {
            rs.next();
            this.verifyTuple(rs);
        }
        this.commit();
        while (rs.next()) {
            this.verifyTuple(rs);
        }
        this.scrollBackward(rs);
        s.close();
    }

    public void testHeldScrollableResultSetScanDone() throws SQLException {
        Statement s = this.createStatement(1004, 1007);
        ResultSet rs = s.executeQuery(selectStatement);
        this.scrollForward(rs);
        this.commit();
        this.scrollBackward(rs);
        s.close();
    }

    public void testHeldScrollableUpdatableResultSetScanInit() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        ResultSet rs = s.executeQuery(selectStatement);
        if (rs.getConcurrency() == 1007) {
            HoldabilityTest.fail((String)"ResultSet concurrency downgraded to CONCUR_READ_ONLY");
        }
        this.commit();
        this.scrollForward(rs);
        this.scrollBackwardAndUpdate(rs);
        s.close();
    }

    public void testHeldScrollableUpdatableResultSetScanInProgress() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        ResultSet rs = s.executeQuery(selectStatement);
        if (rs.getConcurrency() == 1007) {
            HoldabilityTest.fail((String)"ResultSet concurrency downgraded to CONCUR_READ_ONLY");
        }
        for (int i = 0; i < this.recordCount / 2; ++i) {
            rs.next();
            this.verifyTuple(rs);
        }
        this.commit();
        while (rs.next()) {
            this.verifyTuple(rs);
        }
        this.scrollBackwardAndUpdate(rs);
        s.close();
    }

    public void testHeldScrollableUpdatableResultSetScanDone() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        ResultSet rs = s.executeQuery(selectStatement);
        if (rs.getConcurrency() == 1007) {
            HoldabilityTest.fail((String)"ResultSet concurrency downgraded to CONCUR_READ_ONLY");
        }
        this.scrollForward(rs);
        this.commit();
        this.scrollBackwardAndUpdate(rs);
        s.close();
    }

    public void testUpdateRowAfterCommitOnHeldForwardOnlyResultSet() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        ResultSet rs = s.executeQuery(selectStatement);
        if (rs.getConcurrency() == 1007) {
            HoldabilityTest.fail((String)"ResultSet concurrency downgraded to CONCUR_READ_ONLY");
        }
        rs.next();
        this.commit();
        try {
            rs.updateInt(2, -100);
            rs.updateRow();
            HoldabilityTest.fail((String)"Expected updateRow() to throw exception");
        }
        catch (SQLException e) {
            HoldabilityTest.assertEquals((String)"Unexpected SQLState", (String)"24000", (String)e.getSQLState());
        }
        s.close();
    }

    public void testUpdateRowAfterCommitOnHeldScrollInsensitiveResultSet() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        ResultSet rs = s.executeQuery(selectStatement);
        if (rs.getConcurrency() == 1007) {
            HoldabilityTest.fail((String)"ResultSet concurrency downgraded to CONCUR_READ_ONLY");
        }
        rs.next();
        this.commit();
        try {
            rs.updateInt(2, -100);
            rs.updateRow();
            HoldabilityTest.fail((String)"Expected updateRow() to throw exception");
        }
        catch (SQLException e) {
            HoldabilityTest.assertEquals((String)"Unexpected SQLState", (String)"24000", (String)e.getSQLState());
        }
        s.close();
    }

    public void testCompressOnHeldScrollableUpdatableResultSetScanInit() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        ResultSet rs = s.executeQuery(selectStatement);
        if (rs.getConcurrency() == 1007) {
            HoldabilityTest.fail((String)"ResultSet concurrency downgraded to CONCUR_READ_ONLY");
        }
        this.commit();
        this.verifyResultSetUpdatableAfterCompress(rs);
        s.close();
    }

    public void testCompressOnHeldScrollableUpdatableResultSetScanInProgress() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        ResultSet rs = s.executeQuery(selectStatement);
        if (rs.getConcurrency() == 1007) {
            HoldabilityTest.fail((String)"ResultSet concurrency downgraded to CONCUR_READ_ONLY");
        }
        rs.next();
        this.commit();
        this.verifyCompressInvalidation(rs);
        s.close();
    }

    public void testCompressOnHeldScrollableUpdatableResultSetScanDone() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        ResultSet rs = s.executeQuery(selectStatement);
        if (rs.getConcurrency() == 1007) {
            HoldabilityTest.fail((String)"ResultSet concurrency downgraded to CONCUR_READ_ONLY");
        }
        this.scrollForward(rs);
        this.commit();
        this.verifyCompressInvalidation(rs);
        s.close();
    }

    private void verifyResultSetUpdatableAfterCompress(ResultSet rs) throws SQLException {
        Statement delStatement = this.createStatement();
        int deleted = delStatement.executeUpdate("delete from T1 where id>0");
        int expectedDeleted = this.recordCount - 1;
        delStatement.close();
        HoldabilityTest.assertEquals((String)"Invalid number of records deleted", (int)expectedDeleted, (int)deleted);
        this.commit();
        this.onlineCompress(true, true, true);
        PreparedStatement ps = this.prepareStatement("insert into t1 values (?,?,?,?,?)");
        for (int i = 0; i < this.recordCount * 2; ++i) {
            int recordId = i + this.recordCount + 1000;
            ps.setInt(1, recordId);
            ps.setInt(2, recordId);
            ps.setInt(3, recordId * 2 + 17);
            ps.setString(4, "m" + recordId);
            ps.setString(5, "c" + recordId);
            ps.addBatch();
        }
        ps.executeBatch();
        ps.close();
        this.commit();
        rs.next();
        this.updateTuple(rs);
        SQLWarning warn = rs.getWarnings();
        HoldabilityTest.assertNull((String)"Expected no warning when updating this row", (Object)warn);
        if (rs.getType() != 1003) {
            rs.last();
            this.updateTuple(rs);
            warn = rs.getWarnings();
            HoldabilityTest.assertNull((String)"Expected no warning when updating this row", (Object)warn);
            rs.first();
            this.updateTuple(rs);
            warn = rs.getWarnings();
            HoldabilityTest.assertNull((String)"Expected no warning when updating this row", (Object)warn);
        }
        this.commit();
        rs = this.createStatement().executeQuery(selectStatement);
        while (rs.next()) {
            this.verifyTuple(rs);
        }
        rs.close();
    }

    private void verifyCompressInvalidation(ResultSet rs) throws SQLException {
        Statement delStatement = this.createStatement();
        int deleted = delStatement.executeUpdate("delete from T1 where id>0");
        int expectedDeleted = this.recordCount - 1;
        delStatement.close();
        HoldabilityTest.assertEquals((String)"Invalid number of records deleted", (int)expectedDeleted, (int)deleted);
        this.commit();
        this.onlineCompress(true, true, true);
        PreparedStatement ps = this.prepareStatement("insert into t1 values (?,?,?,?,?)");
        for (int i = 0; i < this.recordCount * 2; ++i) {
            int recordId = i + this.recordCount + 1000;
            ps.setInt(1, recordId);
            ps.setInt(2, recordId);
            ps.setInt(3, recordId * 2 + 17);
            ps.setString(4, "m" + recordId);
            ps.setString(5, "c" + recordId);
            ps.addBatch();
        }
        ps.executeBatch();
        ps.close();
        this.commit();
        rs.last();
        rs.updateInt(2, -100);
        rs.updateRow();
        SQLWarning warn = rs.getWarnings();
        this.assertWarning(warn, "01001");
        rs.clearWarnings();
        rs.first();
        rs.updateInt(2, -100);
        this.updateTuple(rs);
        warn = rs.getWarnings();
        this.assertWarning(warn, "01001");
        this.commit();
        rs = this.createStatement().executeQuery(selectStatement);
        while (rs.next()) {
            this.verifyTuple(rs);
        }
        rs.close();
    }

    private void onlineCompress(boolean purge, boolean defragment, boolean truncate) throws SQLException {
        Connection con2 = this.openDefaultConnection();
        con2.setTransactionIsolation(1);
        PreparedStatement ps2 = con2.prepareStatement("call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?,?,?,?,?)");
        ps2.setString(1, "APP");
        ps2.setString(2, "T1");
        ps2.setBoolean(3, purge);
        ps2.setBoolean(4, defragment);
        ps2.setBoolean(5, truncate);
        ps2.executeUpdate();
        ps2.close();
        con2.commit();
        con2.close();
    }
}

