/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memory;

import java.io.IOException;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class MultiByteClobTest
extends BaseJDBCTestCase {
    private static final int LONG_CLOB_LENGTH = 9000000;
    private static final int SHORT_CLOB_LENGTH = 100;
    private static final String LONG_CLOB_LENGTH_STRING = "9000000";
    private static final String SHORT_CLOB_LENGTH_STRING = "100";

    public MultiByteClobTest(String name) {
        super(name);
    }

    public void testSmallMultiByteCharLob() throws SQLException, IOException {
        int size;
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        PreparedStatement ps = this.prepareStatement("INSERT INTO MB_CLOBTABLE VALUES(?,?)");
        ps.setInt(1, 1);
        LoopingAlphabetReader reader = new LoopingAlphabetReader(100L, CharAlphabet.cjkSubset());
        ps.setCharacterStream(2, (Reader)reader, 100);
        ps.executeUpdate();
        ResultSet rs = s.executeQuery("SELECT K, LENGTH(C), C FROM MB_CLOBTABLE-- DERBY-PROPERTIES constraint=pk\n ORDER BY K");
        rs.next();
        MultiByteClobTest.assertEquals((String)SHORT_CLOB_LENGTH_STRING, (String)rs.getString(2));
        Reader rsReader = rs.getCharacterStream(3);
        int len = 0;
        char[] buf = new char[32672];
        while ((size = rsReader.read(buf)) != -1) {
            int expectedValue = ((len += size) - 1) % 12 + 19968;
            if (size == 0) continue;
            MultiByteClobTest.assertEquals((int)expectedValue, (int)buf[size - 1]);
        }
        MultiByteClobTest.assertEquals((int)100, (int)len);
        rs.close();
        rs = s.executeQuery("SELECT K, LENGTH(C)  FROM MB_CLOBTABLE ORDER BY K");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", SHORT_CLOB_LENGTH_STRING}});
    }

    public void testLargeMultiByteCharLob() throws SQLException, IOException {
        int size;
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        PreparedStatement ps = this.prepareStatement("INSERT INTO MB_CLOBTABLE VALUES(?,?)");
        ps.setInt(1, 1);
        LoopingAlphabetReader reader = new LoopingAlphabetReader(9000000L, CharAlphabet.cjkSubset());
        ps.setCharacterStream(2, (Reader)reader, 9000000);
        ps.executeUpdate();
        ResultSet rs = s.executeQuery("SELECT K, LENGTH(C), C FROM MB_CLOBTABLE-- DERBY-PROPERTIES constraint=pk\n ORDER BY K");
        rs.next();
        MultiByteClobTest.assertEquals((String)LONG_CLOB_LENGTH_STRING, (String)rs.getString(2));
        Reader rsReader = rs.getCharacterStream(3);
        int len = 0;
        char[] buf = new char[32672];
        while ((size = rsReader.read(buf)) != -1) {
            int expectedValue = ((len += size) - 1) % 12 + 19968;
            if (size == 0) continue;
            MultiByteClobTest.assertEquals((int)expectedValue, (int)buf[size - 1]);
        }
        MultiByteClobTest.assertEquals((int)9000000, (int)len);
        rs.close();
        rs = s.executeQuery("SELECT K, LENGTH(C)  FROM MB_CLOBTABLE ORDER BY K");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", LONG_CLOB_LENGTH_STRING}});
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("MultiByteClobTest");
        suite.addTest(MultiByteClobTest.baseSuite("MultiByteClobTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(MultiByteClobTest.baseSuite("MultiByteClobTest:client")));
        Properties p = new Properties();
        p.setProperty("derby.storage.pageCacheSize", SHORT_CLOB_LENGTH_STRING);
        return new SystemPropertyTestSetup((Test)suite, p);
    }

    private static Test baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        suite.addTestSuite(MultiByteClobTest.class);
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts((Test)suite, 2, 4)){

            @Override
            protected void decorateSQL(Statement stmt) throws SQLException {
                stmt.execute("CREATE TABLE MB_CLOBTABLE (K INT CONSTRAINT PK PRIMARY KEY, C CLOB(9000000))");
            }
        };
    }
}

