/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.derby.vti.StringColumnVTI;

public abstract class EnumeratorTableFunction
extends StringColumnVTI {
    private Enumeration _enumeration;
    protected String[] _row;

    public EnumeratorTableFunction(String[] columnNames, Object collection) throws SQLException {
        super(columnNames);
        this.setEnumeration(collection);
    }

    protected EnumeratorTableFunction(String[] columnNames) {
        super(columnNames);
    }

    protected void setEnumeration(Object collection) throws SQLException {
        if (collection == null) {
            throw new SQLException("Bad argument. Null collections not allowed.");
        }
        if (collection instanceof Enumeration) {
            this._enumeration = (Enumeration)collection;
        } else if (collection instanceof Iterator) {
            this._enumeration = new Enumerator((Iterator)collection);
        } else if (collection instanceof Iterable) {
            this._enumeration = new Enumerator(((Iterable)collection).iterator());
        } else if (collection.getClass().isArray()) {
            this._enumeration = new ArrayEnumerator(collection);
        } else {
            throw new SQLException("Bad argument. Argument must be an Enumeration, Iterator, Iterable, or array.");
        }
        this._row = new String[this.getColumnCount()];
    }

    public abstract String[] makeRow(Object var1) throws SQLException;

    protected String getRawColumn(int columnNumber) throws SQLException {
        return this._row[columnNumber - 1];
    }

    public boolean next() throws SQLException {
        if (this._enumeration == null) {
            return false;
        }
        if (!this._enumeration.hasMoreElements()) {
            return false;
        }
        Object obj = this._enumeration.nextElement();
        this._row = this.makeRow(obj);
        return true;
    }

    public void close() {
        this._enumeration = null;
        this._row = null;
    }

    public final class ArrayEnumerator
    implements Enumeration {
        Object _array;
        int _length;
        int _idx;
        Object _nextObject;

        public ArrayEnumerator(Object array) {
            this._array = array;
            this._length = Array.getLength(array);
            this._idx = 0;
            this.advance();
        }

        @Override
        public boolean hasMoreElements() {
            return this._nextObject != null;
        }

        public Object nextElement() {
            Object result = this._nextObject;
            this.advance();
            return result;
        }

        private void advance() {
            do {
                if (this._idx >= this._length) {
                    this._nextObject = null;
                    break;
                }
                this._nextObject = Array.get(this._array, this._idx++);
            } while (this._nextObject == null);
        }
    }

    public final class Enumerator
    implements Enumeration {
        private Iterator _iterator;

        public Enumerator(Iterator iterator) {
            this._iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this._iterator.hasNext();
        }

        public Object nextElement() {
            return this._iterator.next();
        }
    }
}

