/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.MiscellaneousStatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.shared.common.error.StandardException;

class SetConstraintsNode
extends MiscellaneousStatementNode {
    private final List<TableName> constraints;
    private final boolean deferred;

    SetConstraintsNode(List<TableName> constraints, boolean deferred, ContextManager cm) {
        super(cm);
        this.constraints = constraints;
        this.deferred = deferred;
    }

    @Override
    public String toString() {
        return super.toString() + this.formatList(this.constraints) + ":" + (this.deferred ? " DEFERRED" : " IMMEDIATE") + "\n";
    }

    String formatList(List<TableName> constraints) {
        StringBuilder sb = new StringBuilder();
        if (constraints == null) {
            return "ALL";
        }
        for (TableName tn : constraints) {
            sb.append(tn);
            sb.append(", ");
        }
        return sb.substring(0, Math.max(0, sb.length() - 2));
    }

    @Override
    public String statementToString() {
        return "SET CONSTRAINTS";
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getSetConstraintsConstantAction(this.constraints, this.deferred);
    }

    @Override
    public void bindStatement() throws StandardException {
        if (this.constraints != null) {
            for (TableName c : this.constraints) {
                c.bind();
            }
        }
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.constraints != null) {
            for (int i = 0; i < this.constraints.size(); ++i) {
                this.constraints.set(i, (TableName)this.constraints.get(i).accept(v));
            }
        }
    }
}

