/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TeeInputStream
extends InputStream {
    private byte[] skipBuffer;
    private InputStream src;
    private OutputStream dst;

    public TeeInputStream(InputStream src, OutputStream dst) {
        this.src = src;
        this.dst = dst;
    }

    public int read() throws IOException {
        byte[] b = this.skipBuffer();
        int n = this.read(b, 0, 1);
        return n == 1 ? b[0] & 0xFF : -1;
    }

    public long skip(long cnt) throws IOException {
        int n;
        long skipped = 0L;
        byte[] b = this.skipBuffer();
        while (0L < cnt && (n = this.src.read(b, 0, (int)Math.min((long)b.length, cnt))) > 0) {
            this.dst.write(b, 0, n);
            skipped += (long)n;
            cnt -= (long)n;
        }
        return skipped;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int n = this.src.read(b, off, len);
        if (0 < n) {
            this.dst.write(b, off, n);
        }
        return n;
    }

    public void close() throws IOException {
        int n;
        byte[] b = this.skipBuffer();
        while ((n = this.src.read(b)) > 0) {
            this.dst.write(b, 0, n);
        }
        this.dst.close();
        this.src.close();
    }

    private byte[] skipBuffer() {
        if (this.skipBuffer == null) {
            this.skipBuffer = new byte[2048];
        }
        return this.skipBuffer;
    }
}

