/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.control;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class Checksums {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final String FILE_ENCODING = "ISO-8859-1";
    private static final byte ZERO_LITERAL_AS_BYTE = 48;
    private static final byte NINE_LITERAL_AS_BYTE = 57;
    private static final byte CHAR_BASE = 55;
    private static final int HEX_BITS_PER_CHAR = 4;
    private static final int HEX_SMALLEST_TWOCHAR_NUMBER = 16;
    private static final int HEX_LARGEST_ONECHAR_NUMBER = 15;
    private static final int HEX_LARGEST_TWOCHAR_NUMBER = 255;
    private static final String SEPARATOR = "-";
    private final Map<String, byte[]> checksums = new HashMap<String, byte[]>();
    private final Map<String, Date> modificationDates = new HashMap<String, Date>();

    public byte[] getChecksum(String name) {
        return this.checksums.get(name);
    }

    public Checksums setChecksum(String name, byte[] checksum) {
        if (checksum == null) {
            throw new NullPointerException("checksum must not be null");
        }
        this.checksums.put(name, checksum);
        return this;
    }

    public Map<String, byte[]> getChecksums() {
        return Collections.unmodifiableMap(this.checksums);
    }

    public Date getModificationDate(String name) {
        return this.modificationDates.get(name);
    }

    public Checksums setModificationDate(String name, Date modificationDate) {
        if (modificationDate == null) {
            throw new NullPointerException("modificationDate must not be null");
        }
        this.modificationDates.put(name, modificationDate);
        return this;
    }

    public Map<String, Date> getModificationDates() {
        return Collections.unmodifiableMap(this.modificationDates);
    }

    public Checksums writeToFile(File toWriteTo) throws IOException {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.checksums.keySet());
        keys.addAll(this.modificationDates.keySet());
        Checksums existing = new Checksums();
        existing.readFromFile(toWriteTo);
        for (String key : existing.getChecksums().keySet()) {
            if (!keys.add(key)) continue;
            this.checksums.put(key, existing.getChecksum(key));
            if (existing.getModificationDate(key) == null) continue;
            this.modificationDates.put(key, existing.getModificationDate(key));
        }
        for (String key : existing.getModificationDates().keySet()) {
            if (!keys.add(key)) continue;
            this.modificationDates.put(key, existing.getModificationDate(key));
        }
        StringBuilder content = new StringBuilder();
        for (String key : keys) {
            Date modificationDate = this.modificationDates.get(key);
            if (modificationDate != null) {
                content.append(modificationDate.getTime());
            }
            content.append(SEPARATOR);
            byte[] checksum = this.checksums.get(key);
            if (checksum != null) {
                for (int j = 0; j < checksum.length; ++j) {
                    int v = checksum[j] & 0xFF;
                    content.append(HEX_ARRAY[v >>> 4]).append(HEX_ARRAY[v & 0xF]);
                }
            }
            content.append(SEPARATOR).append(key).append("\n");
        }
        FileUtils.writeStringToFile((File)toWriteTo, (String)content.toString(), (String)FILE_ENCODING);
        return this;
    }

    public Checksums readFromFile(File toReadFrom) throws IOException {
        this.checksums.clear();
        this.modificationDates.clear();
        if (!toReadFrom.exists()) {
            return this;
        }
        String content = FileUtils.readFileToString((File)toReadFrom, (String)FILE_ENCODING);
        for (String line : StringUtils.split((String)content, (String)"\n")) {
            String name;
            String checksumString;
            String datestring;
            if (StringUtils.isBlank((CharSequence)line)) continue;
            StringTokenizer tokenizer = new StringTokenizer(line, SEPARATOR, true);
            try {
                datestring = tokenizer.nextToken();
                if (SEPARATOR.equals(datestring)) {
                    datestring = null;
                } else if (!SEPARATOR.equals(tokenizer.nextToken())) {
                    throw new IOException("invalid line (no separator after date)" + line);
                }
                checksumString = tokenizer.nextToken();
                if (SEPARATOR.equals(checksumString)) {
                    checksumString = null;
                } else if (!SEPARATOR.equals(tokenizer.nextToken())) {
                    throw new IOException("invalid line (no separator after checksum)" + line);
                }
                name = tokenizer.nextToken("");
            }
            catch (NoSuchElementException e) {
                throw new IOException("invalid line (not enough separators)" + line);
            }
            if (datestring != null) {
                Date modificationDate = new Date(Long.parseLong(datestring));
                this.modificationDates.put(name, modificationDate);
            }
            if (checksumString == null) continue;
            byte[] checksum = new byte[checksumString.length() / 2];
            boolean last = false;
            int currentByte = 0;
            int i = 0;
            for (char hexValue : checksumString.toCharArray()) {
                byte read = hexValue > '9' ? (byte)(hexValue - 55) : (byte)(hexValue - 48);
                if (!last) {
                    currentByte = 16 * read;
                    last = true;
                    continue;
                }
                checksum[i] = (byte)(currentByte += read);
                ++i;
                last = false;
            }
            this.checksums.put(name, checksum);
        }
        return this;
    }
}

