package org.apache.torque.generator.configuration.option;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * The element and attribute names for the option configuration.
 */
public final class OptionTags
{
    /**
     * Private constructor for utility class.
     */
    private OptionTags()
    {
    }

    /** Tag name for the "options" tag. */
    public static final String OPTIONS_TAG = "options";

    /** Attribute name for the "path" attribute of the "options" tag. */
    public static final String OPTIONS_PATH_ATTRIBUTE = "path";

    /** Attribute name for the "type" attribute of the "options" tag. */
    public static final String OPTIONS_TYPE_ATTRIBUTE = "type";
}
