/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.oid;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.torque.adapter.Adapter;
import org.apache.torque.adapter.IDMethod;
import org.apache.torque.oid.AutoIncrementIdGenerator;
import org.apache.torque.oid.IdGenerator;
import org.apache.torque.oid.SequenceIdGenerator;

public final class IDGeneratorFactory {
    public static final List<IDMethod> ID_GENERATOR_METHODS = Collections.unmodifiableList(Stream.of(IDMethod.NATIVE, IDMethod.AUTO_INCREMENT, IDMethod.SEQUENCE).collect(Collectors.toList()));

    private IDGeneratorFactory() {
    }

    public static IdGenerator create(Adapter adapter, String name) {
        switch (adapter.getIDMethodType()) {
            case AUTO_INCREMENT: {
                return new AutoIncrementIdGenerator(adapter, name);
            }
            case SEQUENCE: {
                return new SequenceIdGenerator(adapter, name);
            }
        }
        return null;
    }
}

