/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.lang.reflect.Constructor;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapConnectionFactory;
import org.apache.directory.ldap.client.api.LdapConnectionValidator;
import org.apache.directory.ldap.client.api.LookupLdapConnectionValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPoolableLdapConnectionFactory
implements PoolableObjectFactory<LdapConnection> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPoolableLdapConnectionFactory.class);
    protected LdapConnectionFactory connectionFactory;
    protected LdapConnectionValidator validator = new LookupLdapConnectionValidator();

    public void activateObject(LdapConnection connection) throws LdapException {
        LOG.debug("Activating {}", (Object)connection);
        if (!connection.isConnected() || !connection.isAuthenticated()) {
            LOG.debug("rebind due to connection dropped on {}", (Object)connection);
            this.connectionFactory.bindConnection(connection);
        }
    }

    public void destroyObject(LdapConnection connection) throws LdapException {
        LOG.debug("Destroying {}", (Object)connection);
        try {
            connection.unBind();
        }
        catch (LdapException e) {
            LOG.error("unable to unbind connection: {}", (Object)e.getMessage());
            LOG.debug("unable to unbind connection:", (Throwable)e);
        }
    }

    public LdapApiService getLdapApiService() {
        return this.connectionFactory.getLdapApiService();
    }

    public LdapConnection makeObject() throws LdapException {
        LOG.debug("Creating a LDAP connection");
        return this.connectionFactory.newLdapConnection();
    }

    protected static LdapConnectionFactory newLdapConnectionFactory(LdapConnectionConfig config, Class<? extends LdapConnectionFactory> connectionFactoryClass) {
        try {
            Constructor<? extends LdapConnectionFactory> constructor = connectionFactoryClass.getConstructor(LdapConnectionConfig.class);
            return constructor.newInstance(config);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("unable to create LdapConnectionFactory" + e.getMessage(), e);
        }
    }

    public void passivateObject(LdapConnection connection) throws LdapException {
        LOG.debug("Passivating {}", (Object)connection);
    }

    public void setValidator(LdapConnectionValidator validator) {
        this.validator = validator;
    }

    public boolean validateObject(LdapConnection connection) {
        LOG.debug("Validating {}", (Object)connection);
        return this.validator.validate(connection);
    }
}

