/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message.controls;

import org.apache.directory.api.ldap.model.message.controls.AbstractControl;
import org.apache.directory.api.ldap.model.message.controls.ChangeType;
import org.apache.directory.api.ldap.model.message.controls.PersistentSearch;

public class PersistentSearchImpl
extends AbstractControl
implements PersistentSearch {
    private boolean changesOnly = true;
    private boolean returnECs = false;
    private int changeTypes = CHANGE_TYPES_MAX;

    public PersistentSearchImpl() {
        super("2.16.840.1.113730.3.4.3");
    }

    @Override
    public void setChangesOnly(boolean changesOnly) {
        this.changesOnly = changesOnly;
    }

    @Override
    public boolean isChangesOnly() {
        return this.changesOnly;
    }

    @Override
    public void setReturnECs(boolean returnECs) {
        this.returnECs = returnECs;
    }

    @Override
    public boolean isReturnECs() {
        return this.returnECs;
    }

    @Override
    public void setChangeTypes(int changeTypes) {
        this.changeTypes = changeTypes;
    }

    @Override
    public int getChangeTypes() {
        return this.changeTypes;
    }

    @Override
    public boolean isNotificationEnabled(ChangeType changeType) {
        return (changeType.getValue() & this.changeTypes) > 0;
    }

    @Override
    public void enableNotification(ChangeType changeType) {
        this.changeTypes |= changeType.getValue();
    }

    @Override
    public void disableNotification(ChangeType changeType) {
        this.changeTypes &= ~changeType.getValue();
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        h = h * 37 + (this.changesOnly ? 1 : 0);
        h = h * 37 + (this.returnECs ? 1 : 0);
        h = h * 37 + this.changeTypes;
        return h;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PersistentSearch)) {
            return false;
        }
        PersistentSearch otherControl = (PersistentSearch)other;
        return super.equals(other) && this.changesOnly == otherControl.isChangesOnly() && this.returnECs == otherControl.isReturnECs() && this.changeTypes == otherControl.getChangeTypes();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Persistant Search Control\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        sb.append("        changeTypes : '").append(this.changeTypes).append("'\n");
        sb.append("        changesOnly : '").append(this.changesOnly).append("'\n");
        sb.append("        returnECs   : '").append(this.returnECs).append("'\n");
        return sb.toString();
    }
}

