/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.dubbo.remoting.transport;

import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.serialize.Serialization;
import org.apache.dubbo.common.serialize.support.DefaultSerializationSelector;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;


class CodecSupportTest {

    @Test
    void testHeartbeat() throws Exception {
        Byte proto = CodecSupport.getIDByName(DefaultSerializationSelector.getDefaultRemotingSerialization());
        Serialization serialization = CodecSupport.getSerializationById(proto);
        byte[] nullBytes = CodecSupport.getNullBytesOf(serialization);

        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutput out = serialization.serialize(null, baos);
        out.writeObject(null);
        out.flushBuffer();
        InputStream is = new ByteArrayInputStream(baos.toByteArray());
        baos.close();
        byte[] payload = CodecSupport.getPayload(is);

        Assertions.assertArrayEquals(nullBytes, payload);
        Assertions.assertTrue(CodecSupport.isHeartBeat(payload, proto));
    }
}
