/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.pages;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.empire.exceptions.InvalidOperationException;
import org.apache.empire.jsf2.app.FacesUtils;
import org.apache.empire.jsf2.pages.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageELResolver
extends ELResolver {
    private static final Logger log = LoggerFactory.getLogger(PageELResolver.class);

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            log.warn("PageELResolver:getCommonPropertyType is not implemented!");
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (base == null && property.equals("page")) {
            return Page.class;
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext arg0, Object arg1) {
        log.warn("PageELResolver:getFeatureDescriptors is not implemented!");
        return null;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (base == null && property.equals("page")) {
            Page page;
            UIViewRoot vr = FacesContext.getCurrentInstance().getViewRoot();
            if (vr == null) {
                InvalidOperationException e = new InvalidOperationException("ViewRoot not available. Unable to get Page Bean.");
                log.error(e.getMessage());
                throw e;
            }
            Map vmap = vr.getViewMap(false);
            Page page2 = page = vmap != null ? (Page)vmap.get("page") : null;
            if (page == null) {
                InvalidOperationException e = new InvalidOperationException("Page bean not available for current view.");
                log.error(e.getMessage());
                throw e;
            }
            context.setPropertyResolved(true);
            return page;
        }
        return null;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (base == null && property.equals("page")) {
            context.setPropertyResolved(true);
            return true;
        }
        return false;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (base == null && property.equals("page")) {
            String pageAsString = String.valueOf(FacesUtils.getPage(FacesContext.getCurrentInstance()));
            if (!pageAsString.equals(value)) {
                log.warn("Page instances don't match");
            }
            context.setPropertyResolved(true);
        }
    }
}

