/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.bnd;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.AnalyzerPlugin;
import aQute.bnd.service.Plugin;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.felix.ipojo.bnd.BndJarResourceStore;
import org.apache.felix.ipojo.bnd.BndReporter;
import org.apache.felix.ipojo.bnd.Manifests;
import org.apache.felix.ipojo.bnd.ResourceMetadataProvider;
import org.apache.felix.ipojo.manipulator.ManipulationVisitor;
import org.apache.felix.ipojo.manipulator.MetadataProvider;
import org.apache.felix.ipojo.manipulator.Pojoization;
import org.apache.felix.ipojo.manipulator.ResourceStore;
import org.apache.felix.ipojo.manipulator.metadata.AnnotationMetadataProvider;
import org.apache.felix.ipojo.manipulator.metadata.CacheableMetadataProvider;
import org.apache.felix.ipojo.manipulator.metadata.CompositeMetadataProvider;
import org.apache.felix.ipojo.manipulator.metadata.FileMetadataProvider;
import org.apache.felix.ipojo.manipulator.util.Classpath;
import org.apache.felix.ipojo.manipulator.visitor.check.CheckFieldConsistencyVisitor;
import org.apache.felix.ipojo.manipulator.visitor.writer.ManipulatedResourcesWriter;
import org.apache.felix.ipojo.metadata.Element;

public class PojoizationPlugin
implements Plugin,
AnalyzerPlugin {
    private static final String PROPERTY_METADATA = "metadata";
    private static final String PROPERTY_USE_LOCAL_SCHEMAS = "use-local-schemas";
    private static final String PROPERTY_INCLUDE_EMBED_BUNDLES = "include-embed-bundles";
    private static final String DEFAULT_METADATA = "META-INF/metadata.xml";
    private static final boolean DEFAULT_USE_LOCAL_SCHEMAS = false;
    private static final boolean DEFAULT_INCLUDE_EMBED_BUNDLES = false;
    private String m_metadata = "META-INF/metadata.xml";
    private boolean m_useLocalSchemas = false;
    private boolean m_includeEmbedBundles = false;
    private Reporter m_reporter;

    public void setProperties(Map<String, String> configuration) {
        if (configuration.containsKey(PROPERTY_METADATA)) {
            this.m_metadata = configuration.get(PROPERTY_METADATA);
        }
        if (configuration.containsKey(PROPERTY_USE_LOCAL_SCHEMAS)) {
            this.m_useLocalSchemas = true;
        }
        if (configuration.containsKey(PROPERTY_INCLUDE_EMBED_BUNDLES)) {
            this.m_includeEmbedBundles = true;
        }
    }

    public void setReporter(Reporter reporter) {
        this.m_reporter = reporter;
    }

    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        long start = System.currentTimeMillis();
        BndReporter reporter = new BndReporter(this.m_reporter);
        BndJarResourceStore store = new BndJarResourceStore(analyzer, this.m_reporter);
        store.setIncludeEmbedComponents(this.m_includeEmbedBundles);
        CompositeMetadataProvider provider = this.buildMetadataProvider(analyzer, reporter, store);
        CacheableMetadataProvider cache = new CacheableMetadataProvider((MetadataProvider)provider);
        if (cache.getMetadatas().isEmpty() && !this.hasEmbedComponents(analyzer)) {
            return false;
        }
        List jars = analyzer.getClasspath();
        Jar jar = analyzer.getJar();
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        if (jar != null && jar.getSource() != null) {
            paths.add(jar.getSource().getAbsolutePath());
        }
        for (Jar j : jars) {
            if (j.getSource() == null) continue;
            paths.add(j.getSource().getAbsolutePath());
        }
        Classpath cp = new Classpath(paths);
        this.manipulateComponents(reporter, store, cache, cp.createClassLoader());
        int nbComponents = this.findElements(cache.getMetadatas(), "component").size();
        int nbHandlers = this.findElements(cache.getMetadatas(), "handler").size();
        this.m_reporter.trace("iPOJO manipulation performed performed in %s ms (%d components, %d handlers).", new Object[]{System.currentTimeMillis() - start, nbComponents, nbHandlers});
        return false;
    }

    protected void manipulateComponents(BndReporter reporter, BndJarResourceStore store, CacheableMetadataProvider cache, ClassLoader classLoader) {
        Pojoization pojoization = new Pojoization((org.apache.felix.ipojo.manipulator.Reporter)reporter);
        pojoization.disableAnnotationProcessing();
        if (this.m_useLocalSchemas) {
            pojoization.setUseLocalXSD();
        }
        pojoization.pojoization((ResourceStore)store, (MetadataProvider)cache, this.createVisitor(store, reporter), classLoader);
    }

    protected CompositeMetadataProvider buildMetadataProvider(Analyzer analyzer, BndReporter reporter, BndJarResourceStore store) {
        CompositeMetadataProvider provider = new CompositeMetadataProvider((org.apache.felix.ipojo.manipulator.Reporter)reporter);
        File file = new File(this.m_metadata);
        if (file.exists()) {
            FileMetadataProvider fmp = new FileMetadataProvider(file, (org.apache.felix.ipojo.manipulator.Reporter)reporter);
            fmp.setValidateUsingLocalSchemas(this.m_useLocalSchemas);
            provider.addMetadataProvider((MetadataProvider)fmp);
        } else {
            Resource resource = analyzer.getJar().getResource(this.m_metadata);
            if (resource != null) {
                ResourceMetadataProvider rmp = new ResourceMetadataProvider(resource, (org.apache.felix.ipojo.manipulator.Reporter)reporter);
                rmp.setValidateUsingLocalSchemas(this.m_useLocalSchemas);
                provider.addMetadataProvider((MetadataProvider)rmp);
            }
        }
        provider.addMetadataProvider((MetadataProvider)new AnnotationMetadataProvider((ResourceStore)store, (org.apache.felix.ipojo.manipulator.Reporter)reporter));
        return provider;
    }

    private boolean hasEmbedComponents(Analyzer analyzer) throws Exception {
        return this.m_includeEmbedBundles && Manifests.hasEmbedComponents(analyzer);
    }

    private List<Element> findElements(List<Element> metadatas, String name) {
        ArrayList<Element> found = new ArrayList<Element>();
        for (Element element : metadatas) {
            if (!name.equalsIgnoreCase(element.getName())) continue;
            found.add(element);
        }
        return found;
    }

    protected ManipulationVisitor createVisitor(ResourceStore store, BndReporter reporter) {
        ManipulatedResourcesWriter writer = new ManipulatedResourcesWriter();
        writer.setReporter((org.apache.felix.ipojo.manipulator.Reporter)reporter);
        writer.setResourceStore(store);
        CheckFieldConsistencyVisitor checkFieldConsistencyVisitor = new CheckFieldConsistencyVisitor((ManipulationVisitor)writer);
        checkFieldConsistencyVisitor.setReporter((org.apache.felix.ipojo.manipulator.Reporter)reporter);
        return checkFieldConsistencyVisitor;
    }
}

