/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.online.manipulator;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BridgeClassLoader
extends ClassLoader {
    private final URLClassLoader m_loader;
    private final BundleContext m_context;

    public BridgeClassLoader(File original, BundleContext context) throws MalformedURLException {
        this.m_loader = new URLClassLoader(new URL[]{original.toURI().toURL()}, null);
        this.m_context = context;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            return this.m_loader.loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            for (Bundle bundle : this.m_context.getBundles()) {
                if (bundle.getState() < 4) continue;
                try {
                    return bundle.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    // empty catch block
                }
            }
            return super.loadClass(name);
        }
    }
}

