/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.util;

import com.adobe.internal.fxg.util.AbstractLogger;
import java.io.PrintStream;

public class SystemLogger
extends AbstractLogger {
    public SystemLogger() {
        super(Integer.MAX_VALUE);
    }

    public void log(int level, Object message, Throwable t, String location, int line, int column, Object ... arguments) {
        if (level < this.getLevel()) {
            return;
        }
        PrintStream ps = level > 20000 ? System.err : System.out;
        try {
            StringBuilder sb = new StringBuilder();
            if (location != null) {
                sb.append(location).append(":");
            }
            if (line > 0) {
                sb.append(" Line ").append(line);
                if (column > 0) {
                    sb.append(", Column ").append(column);
                }
            }
            if (message != null) {
                sb.append(": ").append(this.getLocalizedMessage(message.toString(), arguments));
            }
            if (t != null) {
                sb.append(": ").append(t.getLocalizedMessage());
            }
            ps.println(sb.toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

