/*
 * Decompiled with CFR 0.152.
 */
package flash.swf.types;

import flash.swf.SwfEncoder;

public class Matrix {
    public boolean hasScale;
    public int scaleX;
    public int scaleY;
    public boolean hasRotate;
    public int rotateSkew0;
    public int rotateSkew1;
    public int translateX;
    public int translateY;

    public Matrix() {
    }

    public Matrix(int n, int n2) {
        this.translateX = n;
        this.translateY = n2;
    }

    public Matrix(int n, int n2, double d, double d2) {
        this.translateX = n;
        this.translateY = n2;
        this.setScale(d, d2);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Matrix) {
            Matrix matrix = (Matrix)object;
            if (matrix.hasScale == this.hasScale && matrix.scaleX == this.scaleX && matrix.scaleY == this.scaleY && matrix.hasRotate == this.hasRotate && matrix.rotateSkew0 == this.rotateSkew0 && matrix.rotateSkew1 == this.rotateSkew1 && matrix.translateX == this.translateX && matrix.translateY == this.translateY) {
                bl = true;
            }
        }
        return bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.hasScale) {
            stringBuilder.append("s");
            stringBuilder.append((float)((double)this.scaleX / 65536.0)).append(",").append((float)((double)this.scaleY / 65536.0));
            stringBuilder.append(" ");
        }
        if (this.hasRotate) {
            stringBuilder.append("r");
            stringBuilder.append((float)((double)this.rotateSkew0 / 65536.0)).append(",").append((float)((double)this.rotateSkew1 / 65536.0));
            stringBuilder.append(" ");
        }
        stringBuilder.append("t");
        stringBuilder.append(this.translateX).append(",").append(this.translateY);
        return stringBuilder.toString();
    }

    public int nTranslateBits() {
        return SwfEncoder.minBits(SwfEncoder.maxNum(this.translateX, this.translateY, 0, 0), 1);
    }

    public int nRotateBits() {
        return SwfEncoder.minBits(SwfEncoder.maxNum(this.rotateSkew0, this.rotateSkew1, 0, 0), 1);
    }

    public int nScaleBits() {
        return SwfEncoder.minBits(SwfEncoder.maxNum(this.scaleX, this.scaleY, 0, 0), 1);
    }

    public void setRotate(double d, double d2) {
        this.hasRotate = true;
        this.rotateSkew0 = (int)(65536.0 * d);
        this.rotateSkew1 = (int)(65536.0 * d2);
    }

    public void setScale(double d, double d2) {
        this.hasScale = true;
        this.scaleX = (int)(65536.0 * d);
        this.scaleY = (int)(65536.0 * d2);
    }
}

