/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.databinding;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.flex.abc.instructionlist.InstructionList;
import org.apache.flex.abc.semantics.Label;
import org.apache.flex.abc.semantics.MethodInfo;
import org.apache.flex.abc.semantics.Name;
import org.apache.flex.abc.semantics.Namespace;
import org.apache.flex.abc.semantics.Nsset;
import org.apache.flex.abc.visitors.IABCVisitor;
import org.apache.flex.compiler.definitions.INamespaceDefinition;
import org.apache.flex.compiler.internal.abc.FunctionGeneratorHelper;
import org.apache.flex.compiler.internal.as.codegen.CodeGeneratorManager;
import org.apache.flex.compiler.internal.as.codegen.LexicalScope;
import org.apache.flex.compiler.internal.codegen.databinding.BindingInfo;
import org.apache.flex.compiler.internal.definitions.NamespaceDefinition;
import org.apache.flex.compiler.internal.projects.FlexProject;
import org.apache.flex.compiler.internal.scopes.ASScope;
import org.apache.flex.compiler.internal.tree.as.LiteralNode;
import org.apache.flex.compiler.mxml.IMXMLTypeConstants;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.tree.as.IExpressionNode;

public class BindingCodeGenUtils {
    private static final Name NAME_VOID = new Name("void");
    private static final Vector<Name> DEST_METHOD_PARAMS = new Vector();
    private static boolean useSocketForTrace;
    public static final boolean doLog = false;

    public static void generateGetter(IABCVisitor emitter, InstructionList ret, List<IExpressionNode> expressions, LexicalScope enclosing_scope) {
        MethodInfo mi = BindingCodeGenUtils.createGetterMethodInfo();
        mi.setMethodName("bind_getter");
        BindingCodeGenUtils.log(ret, "making bind_getter");
        CodeGeneratorManager.getCodeGenerator().generateMXMLDataBindingGetterFunction(mi, expressions, enclosing_scope);
        ret.addInstruction(64, mi);
    }

    public static void generateSetter(InstructionList ret, IExpressionNode expression, LexicalScope enclosing_scope) {
        MethodInfo mi = BindingCodeGenUtils.createSetterMethodInfo();
        BindingCodeGenUtils.log(ret, "making bind_setter");
        InstructionList stuffToFollowExpression = new InstructionList();
        stuffToFollowExpression.addInstruction(71);
        ArrayList<IExpressionNode> exprs = new ArrayList<IExpressionNode>();
        exprs.add(expression);
        CodeGeneratorManager.getCodeGenerator().generateMXMLDataBindingSetterFunction(mi, expression, enclosing_scope);
        ret.addInstruction(64, mi);
    }

    private static MethodInfo createGetterMethodInfo() {
        MethodInfo mi = new MethodInfo();
        mi.setReturnType(null);
        return mi;
    }

    private static MethodInfo createSetterMethodInfo() {
        MethodInfo mi = new MethodInfo();
        mi.setReturnType(NAME_VOID);
        mi.setParamTypes(DEST_METHOD_PARAMS);
        return mi;
    }

    public static void makeBinding(InstructionList insns, FlexProject project, String destStr, String srcString, InstructionList methodInstr) {
        BindingCodeGenUtils.log(insns, "making binding dest=" + destStr);
        insns.addInstruction(93, project.getBindingClassName());
        insns.addInstruction(208);
        insns.addAll(methodInstr);
        BindingCodeGenUtils.pushString(insns, destStr != null ? destStr : "");
        if (srcString != null) {
            insns.addInstruction(44, srcString);
        } else {
            insns.addInstruction(32);
        }
        insns.addInstruction(74, new Object[]{project.getBindingClassName(), 5});
    }

    private static void pushString(InstructionList insns, String string) {
        assert (string != null);
        insns.addInstruction(44, string);
    }

    public static void makePropertyWatcher(boolean makeStaticWatcher, InstructionList insns, String propertyName, List<String> eventNames, List<BindingInfo> bindingInfo, MethodInfo propertyGetterFunction, FlexProject project) {
        BindingCodeGenUtils.log(insns, "makePropertyWatchercg");
        assert (propertyName != null);
        Name watcherClassName = makeStaticWatcher ? project.getStaticPropertyWatcherClassName() : project.getPropertyWatcherClassName();
        insns.addInstruction(93, watcherClassName);
        BindingCodeGenUtils.pushString(insns, propertyName);
        BindingCodeGenUtils.makeEventNameArray(insns, eventNames);
        BindingCodeGenUtils.makeArrayOfBindingsForWatcher(insns, bindingInfo);
        if (propertyGetterFunction == null) {
            insns.addInstruction(32);
        } else {
            insns.addInstruction(64, propertyGetterFunction);
        }
        insns.addInstruction(74, new Object[]{watcherClassName, 4});
        BindingCodeGenUtils.log(insns, "leave makePropertyWatchercg");
    }

    public static void makeXMLWatcher(InstructionList insns, String propertyName, List<BindingInfo> bindingInfo, FlexProject project) {
        Name watcherClassName = project.getXMLWatcherClassName();
        insns.addInstruction(93, watcherClassName);
        BindingCodeGenUtils.pushString(insns, propertyName);
        BindingCodeGenUtils.makeArrayOfBindingsForWatcher(insns, bindingInfo);
        insns.addInstruction(74, new Object[]{watcherClassName, 2});
    }

    private static boolean makeEventNameArray(InstructionList insns, List<String> eventNames) {
        boolean isStyle = false;
        if (eventNames.isEmpty()) {
            insns.addInstruction(32);
        } else if (eventNames.size() == 1 && eventNames.get(0).equals("isStyle")) {
            isStyle = true;
            insns.addInstruction(32);
        } else {
            for (String eventName : eventNames) {
                insns.addInstruction(44, eventName);
                insns.addInstruction(38);
            }
            insns.addInstruction(85, eventNames.size());
        }
        return isStyle;
    }

    public static void makeFunctionWatcher(InstructionList insns, FlexProject project, IABCVisitor emitter, String functionName, List<String> eventNames, List<BindingInfo> bindingInfo, IExpressionNode[] params) {
        BindingCodeGenUtils.log(insns, "enter makeFunctionWatchercg");
        Name watcherClassName = project.getFunctionReturnWatcherClassName();
        insns.addInstruction(93, watcherClassName);
        BindingCodeGenUtils.pushString(insns, functionName);
        insns.addInstruction(208);
        BindingCodeGenUtils.makeParameterFunction(emitter, insns, params);
        boolean isStyle = BindingCodeGenUtils.makeEventNameArray(insns, eventNames);
        BindingCodeGenUtils.makeArrayOfBindingsForWatcher(insns, bindingInfo);
        if (isStyle) {
            insns.addInstruction(32);
            insns.addInstruction(38);
        }
        insns.addInstruction(74, new Object[]{watcherClassName, isStyle ? 7 : 5});
        BindingCodeGenUtils.log(insns, "leave makeFunctionWatchercg");
    }

    public static void makeParameterFunction(IABCVisitor emitter, InstructionList ret, IExpressionNode[] params) {
        MethodInfo mi = new MethodInfo();
        mi.setReturnType(new Name("Array"));
        InstructionList parameterFunctionBody = new InstructionList();
        parameterFunctionBody.addInstruction(208);
        parameterFunctionBody.addInstruction(48);
        if (params.length == 1 && params[0] instanceof LiteralNode) {
            parameterFunctionBody.addInstruction(44, ((LiteralNode)params[0]).getValue());
            parameterFunctionBody.addInstruction(86, 1);
            parameterFunctionBody.addInstruction(72);
        } else {
            parameterFunctionBody.addInstruction(93, IMXMLTypeConstants.NAME_ARGUMENTERROR);
            parameterFunctionBody.addInstruction(44, "unimp param func");
            parameterFunctionBody.pushNumericConstant(1069L);
            parameterFunctionBody.addInstruction(74, new Object[]{IMXMLTypeConstants.NAME_ARGUMENTERROR, 2});
            parameterFunctionBody.addInstruction(3);
        }
        FunctionGeneratorHelper.generateFunction(emitter, mi, parameterFunctionBody);
        ret.addInstruction(64, mi);
    }

    public static void trace(InstructionList insns, String string) {
        BindingCodeGenUtils.pushString(insns, string);
        BindingCodeGenUtils.trace(insns);
        insns.addInstruction(41);
    }

    public static void trace(InstructionList insns) {
        insns.addInstruction(42);
        if (!useSocketForTrace) {
            System.out.println("** Warning: diagnostic trace not using socket. Will be invisible when running most unit tests");
            insns.addInstruction(93, new Object[]{new Name("trace")});
            insns.addInstruction(43);
            insns.addInstruction(79, new Object[]{new Name("trace"), 1});
        } else {
            insns.addInstruction(93, new Object[]{new Name("SocketHelper")});
            insns.addInstruction(102, new Object[]{new Name("SocketHelper")});
            insns.addInstruction(43);
            insns.addInstruction(79, new Object[]{new Name("trace"), 1});
        }
    }

    private static void makeArrayOfBindingsForWatcher(InstructionList insns, List<BindingInfo> bindingInfos) {
        assert (bindingInfos.size() > 0);
        for (BindingInfo bindingInfo : bindingInfos) {
            insns.addInstruction(209);
            insns.pushNumericConstant(bindingInfo.getIndex());
            insns.addInstruction(102, IMXMLTypeConstants.NAME_ARRAYINDEXPROP);
        }
        insns.addInstruction(86, bindingInfos.size());
    }

    private static Name makeNameForPropertyLookup(ICompilerProject project, ASScope scope) {
        Set<INamespaceDefinition> namespaceSet = scope.getNamespaceSet(project);
        ArrayList<Namespace> ns_set = new ArrayList<Namespace>(namespaceSet.size());
        for (INamespaceDefinition namespace : namespaceSet) {
            ns_set.add(((NamespaceDefinition)namespace).getAETNamespace());
        }
        int nameKind = 27;
        String name = null;
        Name n = new Name(nameKind, new Nsset(ns_set), name);
        return n;
    }

    public static MethodInfo generatePropertyGetterFunction(IABCVisitor emitter, ICompilerProject project, ASScope scope) {
        MethodInfo mi = new MethodInfo();
        mi.setReturnType(null);
        Vector<Name> x = new Vector<Name>();
        x.add(new Name("String"));
        mi.setParamTypes(x);
        Name magicName = BindingCodeGenUtils.makeNameForPropertyLookup(project, scope);
        InstructionList propertyGetterBody = new InstructionList();
        propertyGetterBody.addInstruction(8, 0);
        propertyGetterBody.addInstruction(209);
        propertyGetterBody.addInstruction(94, magicName);
        propertyGetterBody.addInstruction(209);
        propertyGetterBody.addInstruction(102, magicName);
        propertyGetterBody.addInstruction(72);
        FunctionGeneratorHelper.generateFunction(emitter, mi, propertyGetterBody);
        return mi;
    }

    public static InstructionList fireInitialBindings() {
        InstructionList insns = new InstructionList();
        BindingCodeGenUtils.log(insns, "fireInitialBinding");
        insns.addInstruction(36, 0);
        insns.addInstruction(213);
        insns.addInstruction(208);
        insns.addInstruction(102, IMXMLTypeConstants.NAME_BINDINGS);
        insns.addInstruction(42);
        insns.addInstruction(102, new Name("length"));
        insns.addInstruction(214);
        Label label = new Label();
        insns.addInstruction(9);
        insns.labelCurrent(label);
        insns.addInstruction(42);
        insns.addInstruction(209);
        insns.addInstruction(102, IMXMLTypeConstants.NAME_ARRAYINDEXPROP);
        insns.addInstruction(79, IMXMLTypeConstants.ARG_EXECUTE);
        insns.addInstruction(194, 1);
        insns.addInstruction(209);
        insns.addInstruction(210);
        insns.addInstruction(21, label);
        insns.addInstruction(41);
        return insns;
    }

    public static void log(String s) {
    }

    public static void log(InstructionList insns, String s) {
        assert (s != null);
    }

    private BindingCodeGenUtils() {
    }

    static {
        DEST_METHOD_PARAMS.add(null);
        useSocketForTrace = false;
    }
}

