/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.filespecs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.flex.compiler.internal.filespecs.IZipFileSpecification;

public class ZipFileSpecification
implements IZipFileSpecification {
    private ZipFile zipFile;
    private long lastModified;
    private String path;

    public ZipFileSpecification(File file) throws ZipException, IOException {
        this.zipFile = new ZipFile(file);
        this.lastModified = file.lastModified();
        this.path = file.getPath();
    }

    @Override
    public Iterator<String> getEntries() {
        return new IteratorImplementation();
    }

    @Override
    public InputStream getEntryStream(String name) throws IOException {
        if (this.zipFile != null) {
            ZipEntry entry = this.zipFile.getEntry(name);
            if (entry != null) {
                return this.zipFile.getInputStream(entry);
            }
            entry = this.zipFile.getEntry("/" + name);
            if (entry != null) {
                return this.zipFile.getInputStream(entry);
            }
        }
        throw new IOException("File not found");
    }

    @Override
    public void close() throws IOException {
        if (this.zipFile == null) {
            return;
        }
        this.zipFile.close();
        this.zipFile = null;
    }

    @Override
    public boolean hasEntry(String entryName) {
        ZipEntry entry = this.zipFile.getEntry(entryName);
        if (entry == null) {
            return this.zipFile.getEntry("/" + entryName) != null;
        }
        return true;
    }

    @Override
    public Reader createReader() throws FileNotFoundException {
        return null;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public boolean isOpenDocument() {
        return false;
    }

    private class IteratorImplementation
    implements Iterator<String> {
        private Enumeration<? extends ZipEntry> enumeration;

        public IteratorImplementation() {
            this.enumeration = ZipFileSpecification.this.zipFile.entries();
        }

        @Override
        public void remove() {
        }

        @Override
        public String next() {
            ZipEntry element = this.enumeration.nextElement();
            return element.getName();
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }
    }
}

