/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.tree.as.metadata;

import org.apache.flex.compiler.definitions.IClassDefinition;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.internal.tree.as.IdentifierNode;
import org.apache.flex.compiler.internal.tree.as.metadata.BaseDefinitionMetaTagNode;
import org.apache.flex.compiler.tree.as.ICommonClassNode;
import org.apache.flex.compiler.tree.metadata.IEffectTagNode;
import org.apache.flex.compiler.workspaces.IWorkspace;

public final class EffectTagNode
extends BaseDefinitionMetaTagNode
implements IEffectTagNode {
    private IdentifierNode eventName;

    public EffectTagNode() {
        super("Effect");
    }

    public void setEvent(IdentifierNode event) {
        if (this.eventName == null) {
            this.eventName = event;
            if (this.eventName != null) {
                this.eventName.setParent(this);
                this.addToMap("event", this.getEventName());
            }
        }
    }

    @Override
    public String getEventName() {
        return this.eventName != null ? this.eventName.getName() : "";
    }

    public IdentifierNode getEventNode() {
        return this.eventName;
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        this.addChildInOrder(this.nameNode, fillInOffsets);
        this.addChildInOrder(this.eventName, fillInOffsets);
    }

    @Override
    protected int getInitialChildCount() {
        return 2;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof EffectTagNode) {
            if (!this.equals(((EffectTagNode)obj).nameNode, this.nameNode)) {
                return false;
            }
            if (!this.equals(((EffectTagNode)obj).eventName, this.eventName)) {
                return false;
            }
        } else {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public IDefinition getDefinition() {
        ICommonClassNode decoratedClassNode = (ICommonClassNode)this.getAncestorOfType(ICommonClassNode.class);
        if (decoratedClassNode == null) {
            return null;
        }
        IWorkspace workspace = this.getWorkspace();
        IClassDefinition decoratedClassDefinition = decoratedClassNode.getDefinition();
        assert (decoratedClassDefinition != null);
        return decoratedClassDefinition.getEffectDefinition(workspace, this.getName());
    }
}

