/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.swc;

import java.io.File;
import java.io.IOException;
import org.apache.flex.compiler.internal.caches.AssetTagCache;
import org.apache.flex.compiler.internal.caches.CSSDocumentCache;
import org.apache.flex.compiler.internal.caches.CacheStoreKeyBase;
import org.apache.flex.compiler.internal.caches.ConcurrentCacheStoreBase;
import org.apache.flex.compiler.internal.caches.FileScopeCache;
import org.apache.flex.compiler.internal.caches.SWFCache;
import org.apache.flex.compiler.workspaces.IWorkspace;
import org.apache.flex.swc.ISWC;
import org.apache.flex.swc.ISWCLibrary;
import org.apache.flex.swc.ISWCManager;
import org.apache.flex.swc.ISWCScript;
import org.apache.flex.swc.io.SWCReader;

public class SWCManager
extends ConcurrentCacheStoreBase<ISWC>
implements ISWCManager {
    private final SWFCache swfCache = new SWFCache(this);
    private final FileScopeCache fileScopeCache = new FileScopeCache(this);
    private final AssetTagCache assetTagCache = new AssetTagCache(this);
    private final CSSDocumentCache cssDocumentCache = new CSSDocumentCache();
    private final IWorkspace workspace;

    public SWCManager(IWorkspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public SWFCache getSWFCache() {
        return this.swfCache;
    }

    @Override
    public FileScopeCache getFileScopeCache() {
        return this.fileScopeCache;
    }

    @Override
    public AssetTagCache getAssetTagCache() {
        return this.assetTagCache;
    }

    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    @Override
    protected ISWC createEntryValue(CacheStoreKeyBase key) {
        if (key instanceof SWCCacheKey) {
            SWCCacheKey cacheKey = (SWCCacheKey)key;
            SWCReader reader = new SWCReader(cacheKey.file, this.workspace.getASDocDelegate().getPackageDitaParser());
            ISWC swc = reader.getSWC();
            assert (swc != null) : "Expect a SWC model object.";
            return swc;
        }
        throw new IllegalArgumentException("Expected a SWCCacheKey.");
    }

    @Override
    public ISWC get(File file) {
        ISWC result = (ISWC)this.get(new SWCCacheKey(file));
        return result;
    }

    @Override
    public void remove(File file) {
        ISWC removedSWC = (ISWC)this.remove(new SWCCacheKey(file));
        if (removedSWC == null) {
            return;
        }
        for (ISWCLibrary lib : removedSWC.getLibraries()) {
            String librarySWFPath = lib.getPath();
            for (ISWCScript script : lib.getScripts()) {
                this.fileScopeCache.remove(FileScopeCache.createKey(removedSWC, librarySWFPath, script));
                for (String scriptDefQName : script.getDefinitions()) {
                    this.assetTagCache.remove(AssetTagCache.createKey(removedSWC, librarySWFPath, script, scriptDefQName));
                }
            }
            this.swfCache.remove(SWFCache.createKey(removedSWC, lib.getPath()));
        }
        for (String defaultsCSSFileName : CSSDocumentCache.ALL_DEFAULTS_CSS_FILENAMES) {
            this.cssDocumentCache.remove(CSSDocumentCache.createKey(removedSWC, defaultsCSSFileName));
        }
        for (String fileInSWC : removedSWC.getFiles().keySet()) {
            this.swfCache.remove(SWFCache.createKey(removedSWC, fileInSWC));
        }
    }

    @Override
    public CSSDocumentCache getCSSDocumentCache() {
        return this.cssDocumentCache;
    }

    public static class SWCCacheKey
    extends CacheStoreKeyBase {
        private final File file;

        public SWCCacheKey(File file) {
            assert (file != null) : "SWC file can't be null.";
            this.file = file;
        }

        @Override
        public String generateKey() {
            try {
                return this.file.getCanonicalPath();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

