/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package org.apache.flex.compiler.tree.as;

/**
 * An AST node representing a container of other nodes, such as a parameter list.
 */
public interface IContainerNode extends IASNode
{
    enum ContainerType
    {
        /**
         * A container wrapped in parenthesis: {@code (...)}
         */
        PARENTHESIS,
        
        /**
         * A container wrapped in curly braces: <code>{...}</code>
         */
        BRACES,
        
        /**
         * A container wrapped in square brackets: {@code [...]}
         */
        BRACKETS,
        
        /**
         * An implicit container is the imaginary block around a single
         * statement:
         * 
         * <pre>
         * if (condition)
         *     trace("true")
         * </pre>
         * 
         * There will be an "implicit" block around {@code trace("true")}.
         */
        IMPLICIT,
        
        /**
         * A "synthesized" block is a generated by tree fix-up logic. For
         * example:
         * 
         * <pre>
         * try
         * // missing block
         * </pre>
         * 
         * There will be a "synthesized" block as a children of the "try" node.
         */
        SYNTHESIZED,

        /**
         * A block gated with a configuration condition expression:
         * 
         * <pre>
         * CONFIG::debug {
         *     x = 10;
         * }
         * </pre>
         */
        CONFIG_BLOCK
    }

    /**
     * Returns the type of the container that his node represents
     * 
     * @return the {@link ContainerType} or null
     */
    ContainerType getContainerType();
}
