/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.BasicTypeComparator;
import org.apache.flink.api.common.typeutils.base.NormalizedKeyUtil;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;

@Internal
public final class BooleanComparator
extends BasicTypeComparator<Boolean> {
    private static final long serialVersionUID = 1L;

    public BooleanComparator(boolean ascending) {
        super(ascending);
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        int fs = firstSource.readBoolean() ? 1 : 0;
        int ss = secondSource.readBoolean() ? 1 : 0;
        int comp = fs - ss;
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return true;
    }

    @Override
    public int getNormalizeKeyLen() {
        return 1;
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < 1;
    }

    @Override
    public void putNormalizedKey(Boolean value, MemorySegment target, int offset, int numBytes) {
        NormalizedKeyUtil.putBooleanNormalizedKey(value, target, offset, numBytes);
    }

    public BooleanComparator duplicate() {
        return new BooleanComparator(this.ascendingComparison);
    }
}

