/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.MutableVertexParallelismStore;
import org.apache.flink.runtime.scheduler.VertexParallelismInformation;

public class DefaultVertexParallelismStore
implements MutableVertexParallelismStore {
    private final Map<JobVertexID, VertexParallelismInformation> vertexToParallelismInfo = new HashMap<JobVertexID, VertexParallelismInformation>();

    @Override
    public void setParallelismInfo(JobVertexID vertexId, VertexParallelismInformation info) {
        this.vertexToParallelismInfo.put(vertexId, info);
    }

    @Override
    public VertexParallelismInformation getParallelismInfo(JobVertexID vertexId) {
        return Optional.ofNullable(this.vertexToParallelismInfo.get(vertexId)).orElseThrow(() -> new IllegalStateException(String.format("No parallelism information set for vertex %s", vertexId)));
    }
}

