/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.io.StreamTwoInputProcessorFactory;
import org.apache.flink.streaming.runtime.io.checkpointing.CheckpointBarrierHandler;
import org.apache.flink.streaming.runtime.io.checkpointing.CheckpointedInputGate;
import org.apache.flink.streaming.runtime.io.checkpointing.InputProcessorUtil;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.tasks.AbstractTwoInputStreamTask;
import org.apache.flink.util.Preconditions;

@Internal
public class TwoInputStreamTask<IN1, IN2, OUT>
extends AbstractTwoInputStreamTask<IN1, IN2, OUT> {
    @Nullable
    private CheckpointBarrierHandler checkpointBarrierHandler;

    public TwoInputStreamTask(Environment env) throws Exception {
        super(env);
    }

    @Override
    protected Optional<CheckpointBarrierHandler> getCheckpointBarrierHandler() {
        return Optional.ofNullable(this.checkpointBarrierHandler);
    }

    @Override
    protected void createInputProcessor(List<IndexedInputGate> inputGates1, List<IndexedInputGate> inputGates2, Function<Integer, StreamPartitioner<?>> gatePartitioners) {
        this.checkpointBarrierHandler = InputProcessorUtil.createCheckpointBarrierHandler(this, this.configuration, this.getCheckpointCoordinator(), this.getTaskNameWithSubtaskAndId(), new List[]{inputGates1, inputGates2}, Collections.emptyList(), this.mainMailboxExecutor, this.systemTimerService);
        CheckpointedInputGate[] checkpointedInputGates = InputProcessorUtil.createCheckpointedMultipleInputGate(this.mainMailboxExecutor, new List[]{inputGates1, inputGates2}, this.getEnvironment().getMetricGroup().getIOMetricGroup(), this.checkpointBarrierHandler, this.configuration);
        Preconditions.checkState(checkpointedInputGates.length == 2);
        this.inputProcessor = StreamTwoInputProcessorFactory.create(this, checkpointedInputGates, this.getEnvironment().getIOManager(), this.getEnvironment().getMemoryManager(), this.getEnvironment().getMetricGroup().getIOMetricGroup(), (TwoInputStreamOperator)this.mainOperator, this.input1WatermarkGauge, this.input2WatermarkGauge, this.operatorChain, this.getConfiguration(), this.getEnvironment().getTaskConfiguration(), this.getJobConfiguration(), this.getExecutionConfig(), this.getUserCodeClassLoader(), this.setupNumRecordsInCounter(this.mainOperator), this.getEnvironment().getTaskStateManager().getInputRescalingDescriptor(), gatePartitioners, this.getEnvironment().getTaskInfo());
    }
}

