/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.AlterOperation;

public class AlterDatabaseOperation
implements AlterOperation {
    private final String catalogName;
    private final String databaseName;
    private final CatalogDatabase catalogDatabase;

    public AlterDatabaseOperation(String catalogName, String databaseName, CatalogDatabase catalogDatabase) {
        this.catalogName = catalogName;
        this.databaseName = databaseName;
        this.catalogDatabase = catalogDatabase;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public CatalogDatabase getCatalogDatabase() {
        return this.catalogDatabase;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("alterDatabase", this.catalogDatabase.getProperties());
        params.put("catalogName", this.catalogName);
        params.put("databaseName", this.databaseName);
        return OperationUtils.formatWithChildren("ALTER DATABASE", params, Collections.emptyList(), Operation::asSummaryString);
    }
}

