/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.flink.orc.vector;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.columnar.vector.TimestampColumnVector;
import org.apache.flink.table.store.shaded.org.apache.flink.orc.vector.AbstractOrcColumnVector;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;

public class OrcLegacyTimestampColumnVector
extends AbstractOrcColumnVector
implements TimestampColumnVector {
    private final LongColumnVector hiveVector;

    OrcLegacyTimestampColumnVector(LongColumnVector vector) {
        super(vector);
        this.hiveVector = vector;
    }

    @Override
    public TimestampData getTimestamp(int i, int precision) {
        int index = this.hiveVector.isRepeating ? 0 : i;
        Timestamp timestamp = OrcLegacyTimestampColumnVector.toTimestamp(this.hiveVector.vector[index]);
        return TimestampData.fromTimestamp(timestamp);
    }

    public static ColumnVector createFromConstant(int batchSize, Object value) {
        LongColumnVector res = new LongColumnVector(batchSize);
        if (value == null) {
            res.noNulls = false;
            res.isNull[0] = true;
            res.isRepeating = true;
        } else {
            Timestamp timestamp = value instanceof LocalDateTime ? Timestamp.valueOf((LocalDateTime)value) : (Timestamp)value;
            res.fill(OrcLegacyTimestampColumnVector.fromTimestamp(timestamp));
            res.isNull[0] = false;
        }
        return res;
    }

    private static long fromTimestamp(Timestamp timestamp) {
        long time = timestamp.getTime();
        int nanos = timestamp.getNanos();
        return time * 1000000L + (long)(nanos % 1000000);
    }

    private static Timestamp toTimestamp(long timeInNanoSec) {
        long integralSecInMillis = timeInNanoSec / 1000000000L * 1000L;
        long nanos = timeInNanoSec % 1000000000L;
        if (nanos < 0L) {
            nanos = 1000000000L + nanos;
            integralSecInMillis = (timeInNanoSec / 1000000000L - 1L) * 1000L;
        }
        Timestamp res = new Timestamp(0L);
        res.setTime(integralSecInMillis);
        res.setNanos((int)nanos);
        return res;
    }
}

