/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.DualInputOperator;
import org.apache.flink.api.common.operators.util.UserCodeClassWrapper;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;

@Internal
public abstract class JoinOperatorBase<IN1, IN2, OUT, FT extends FlatJoinFunction<IN1, IN2, OUT>>
extends DualInputOperator<IN1, IN2, OUT, FT> {
    private JoinHint joinHint = JoinHint.OPTIMIZER_CHOOSES;
    private Partitioner<?> partitioner;

    public JoinOperatorBase(UserCodeWrapper<FT> udf, BinaryOperatorInformation<IN1, IN2, OUT> operatorInfo, int[] keyPositions1, int[] keyPositions2, String name) {
        super(udf, operatorInfo, keyPositions1, keyPositions2, name);
    }

    public JoinOperatorBase(FT udf, BinaryOperatorInformation<IN1, IN2, OUT> operatorInfo, int[] keyPositions1, int[] keyPositions2, String name) {
        super(new UserCodeObjectWrapper<FT>(udf), operatorInfo, keyPositions1, keyPositions2, name);
    }

    public JoinOperatorBase(Class<? extends FT> udf, BinaryOperatorInformation<IN1, IN2, OUT> operatorInfo, int[] keyPositions1, int[] keyPositions2, String name) {
        super(new UserCodeClassWrapper<FT>(udf), operatorInfo, keyPositions1, keyPositions2, name);
    }

    public void setJoinHint(JoinHint joinHint) {
        if (joinHint == null) {
            throw new IllegalArgumentException("Join Hint must not be null.");
        }
        this.joinHint = joinHint;
    }

    public JoinHint getJoinHint() {
        return this.joinHint;
    }

    public void setCustomPartitioner(Partitioner<?> partitioner) {
        this.partitioner = partitioner;
    }

    public Partitioner<?> getCustomPartitioner() {
        return this.partitioner;
    }

    @Public
    public static enum JoinHint {
        OPTIMIZER_CHOOSES,
        BROADCAST_HASH_FIRST,
        BROADCAST_HASH_SECOND,
        REPARTITION_HASH_FIRST,
        REPARTITION_HASH_SECOND,
        REPARTITION_SORT_MERGE;

    }
}

