/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.source.reader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class RecordsBySplits<E>
implements RecordsWithSplitIds<E> {
    private final Set<String> finishedSplits;
    private final Iterator<Map.Entry<String, Collection<E>>> splitsIterator;
    @Nullable
    private Iterator<E> recordsInCurrentSplit;

    public RecordsBySplits(Map<String, Collection<E>> recordsBySplit, Set<String> finishedSplits) {
        this.splitsIterator = Preconditions.checkNotNull(recordsBySplit, "recordsBySplit").entrySet().iterator();
        this.finishedSplits = Preconditions.checkNotNull(finishedSplits, "finishedSplits");
    }

    @Override
    @Nullable
    public String nextSplit() {
        if (this.splitsIterator.hasNext()) {
            Map.Entry<String, Collection<E>> next = this.splitsIterator.next();
            this.recordsInCurrentSplit = next.getValue().iterator();
            return next.getKey();
        }
        return null;
    }

    @Override
    @Nullable
    public E nextRecordFromSplit() {
        if (this.recordsInCurrentSplit == null) {
            throw new IllegalStateException();
        }
        return this.recordsInCurrentSplit.hasNext() ? (E)this.recordsInCurrentSplit.next() : null;
    }

    @Override
    public Set<String> finishedSplits() {
        return this.finishedSplits;
    }

    public static class Builder<E> {
        private final Map<String, Collection<E>> recordsBySplits = new LinkedHashMap<String, Collection<E>>();
        private final Set<String> finishedSplits = new HashSet<String>(2);

        public void add(String splitId, E record) {
            this.recordsBySplits.computeIfAbsent(splitId, sid -> new ArrayList()).add(record);
        }

        public void add(SourceSplit split, E record) {
            this.add(split.splitId(), record);
        }

        public void addAll(String splitId, Collection<E> records) {
            this.recordsBySplits.compute(splitId, (id, r) -> {
                if (r == null) {
                    r = records;
                } else {
                    r.addAll(records);
                }
                return r;
            });
        }

        public void addAll(SourceSplit split, Collection<E> records) {
            this.addAll(split.splitId(), records);
        }

        public void addFinishedSplit(String splitId) {
            this.finishedSplits.add(splitId);
        }

        public void addFinishedSplits(Collection<String> splitIds) {
            this.finishedSplits.addAll(splitIds);
        }

        public RecordsBySplits<E> build() {
            return new RecordsBySplits(this.recordsBySplits.isEmpty() ? Collections.emptyMap() : this.recordsBySplits, this.finishedSplits.isEmpty() ? Collections.emptySet() : this.finishedSplits);
        }
    }
}

