/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.config.memory;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.util.Preconditions;

public class JvmMetaspaceAndOverhead
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MemorySize metaspace;
    private final MemorySize overhead;

    public JvmMetaspaceAndOverhead(MemorySize jvmMetaspace, MemorySize jvmOverhead) {
        this.metaspace = Preconditions.checkNotNull(jvmMetaspace);
        this.overhead = Preconditions.checkNotNull(jvmOverhead);
    }

    MemorySize getTotalJvmMetaspaceAndOverheadSize() {
        return this.getMetaspace().add(this.getOverhead());
    }

    public MemorySize getMetaspace() {
        return this.metaspace;
    }

    public MemorySize getOverhead() {
        return this.overhead;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JvmMetaspaceAndOverhead) {
            JvmMetaspaceAndOverhead that = (JvmMetaspaceAndOverhead)obj;
            return Objects.equals(this.metaspace, that.metaspace) && Objects.equals(this.overhead, that.overhead);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.metaspace, this.overhead);
    }
}

