/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.windows;

import java.io.IOException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.api.windowing.windows.Window;

@PublicEvolving
public class GlobalWindow
extends Window {
    private static final GlobalWindow INSTANCE = new GlobalWindow();

    private GlobalWindow() {
    }

    public static GlobalWindow get() {
        return INSTANCE;
    }

    @Override
    public long maxTimestamp() {
        return Long.MAX_VALUE;
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "GlobalWindow";
    }

    public static class Serializer
    extends TypeSerializerSingleton<GlobalWindow> {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isImmutableType() {
            return true;
        }

        @Override
        public GlobalWindow createInstance() {
            return INSTANCE;
        }

        @Override
        public GlobalWindow copy(GlobalWindow from) {
            return from;
        }

        @Override
        public GlobalWindow copy(GlobalWindow from, GlobalWindow reuse) {
            return from;
        }

        @Override
        public int getLength() {
            return 1;
        }

        @Override
        public void serialize(GlobalWindow record, DataOutputView target) throws IOException {
            target.writeByte(0);
        }

        @Override
        public GlobalWindow deserialize(DataInputView source) throws IOException {
            source.readByte();
            return INSTANCE;
        }

        @Override
        public GlobalWindow deserialize(GlobalWindow reuse, DataInputView source) throws IOException {
            source.readByte();
            return INSTANCE;
        }

        @Override
        public void copy(DataInputView source, DataOutputView target) throws IOException {
            source.readByte();
            target.writeByte(0);
        }

        @Override
        public TypeSerializerSnapshot<GlobalWindow> snapshotConfiguration() {
            return new GlobalWindowSerializerSnapshot();
        }

        public static final class GlobalWindowSerializerSnapshot
        extends SimpleTypeSerializerSnapshot<GlobalWindow> {
            public GlobalWindowSerializerSnapshot() {
                super(Serializer::new);
            }
        }
    }
}

