/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.translators;

import java.util.Collection;
import java.util.Collections;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.streaming.api.graph.SimpleTransformationTranslator;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.TransformationTranslator;
import org.apache.flink.streaming.api.operators.SourceOperatorFactory;
import org.apache.flink.streaming.api.transformations.SourceTransformation;
import org.apache.flink.util.Preconditions;

@Internal
public class SourceTransformationTranslator<OUT, SplitT extends SourceSplit, EnumChkT>
extends SimpleTransformationTranslator<OUT, SourceTransformation<OUT, SplitT, EnumChkT>> {
    @Override
    protected Collection<Integer> translateForBatchInternal(SourceTransformation<OUT, SplitT, EnumChkT> transformation, TransformationTranslator.Context context) {
        return this.translateInternal(transformation, context, false);
    }

    @Override
    protected Collection<Integer> translateForStreamingInternal(SourceTransformation<OUT, SplitT, EnumChkT> transformation, TransformationTranslator.Context context) {
        return this.translateInternal(transformation, context, true);
    }

    private Collection<Integer> translateInternal(SourceTransformation<OUT, SplitT, EnumChkT> transformation, TransformationTranslator.Context context, boolean emitProgressiveWatermarks) {
        Preconditions.checkNotNull(transformation);
        Preconditions.checkNotNull(context);
        StreamGraph streamGraph = context.getStreamGraph();
        String slotSharingGroup = context.getSlotSharingGroup();
        int transformationId = transformation.getId();
        ExecutionConfig executionConfig = streamGraph.getExecutionConfig();
        SourceOperatorFactory<OUT> operatorFactory = new SourceOperatorFactory<OUT>(transformation.getSource(), transformation.getWatermarkStrategy(), emitProgressiveWatermarks);
        operatorFactory.setChainingStrategy(transformation.getChainingStrategy());
        streamGraph.addSource(transformationId, slotSharingGroup, transformation.getCoLocationGroupKey(), operatorFactory, null, transformation.getOutputType(), "Source: " + transformation.getName());
        int parallelism = transformation.getParallelism() != -1 ? transformation.getParallelism() : executionConfig.getParallelism();
        streamGraph.setParallelism(transformationId, parallelism);
        streamGraph.setMaxParallelism(transformationId, transformation.getMaxParallelism());
        return Collections.singleton(transformationId);
    }
}

