/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.api.CompiledPlan;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TablePipeline;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.internal.TablePipelineImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;

@Internal
public class StatementSetImpl<E extends TableEnvironmentInternal>
implements StatementSet {
    protected final E tableEnvironment;
    protected final List<ModifyOperation> operations = new ArrayList<ModifyOperation>();

    protected StatementSetImpl(E tableEnvironment) {
        this.tableEnvironment = tableEnvironment;
    }

    @VisibleForTesting
    public List<ModifyOperation> getOperations() {
        return this.operations;
    }

    @Override
    public StatementSet add(TablePipeline tablePipeline) {
        this.operations.add(((TablePipelineImpl)tablePipeline).getOperation());
        return this;
    }

    @Override
    public StatementSet addInsertSql(String statement) {
        List<Operation> operations = this.tableEnvironment.getParser().parse(statement);
        if (operations.size() != 1) {
            throw new TableException("Only single statement is supported.");
        }
        Operation operation = operations.get(0);
        if (!(operation instanceof ModifyOperation)) {
            throw new TableException("Only insert statement is supported now.");
        }
        this.operations.add((ModifyOperation)operation);
        return this;
    }

    @Override
    public StatementSet addInsert(String targetPath, Table table) {
        return this.add(table.insertInto(targetPath));
    }

    @Override
    public StatementSet addInsert(String targetPath, Table table, boolean overwrite) {
        return this.add(table.insertInto(targetPath, overwrite));
    }

    @Override
    public StatementSet addInsert(TableDescriptor targetDescriptor, Table table) {
        return this.add(table.insertInto(targetDescriptor));
    }

    @Override
    public StatementSet addInsert(TableDescriptor targetDescriptor, Table table, boolean overwrite) {
        return this.add(table.insertInto(targetDescriptor, overwrite));
    }

    @Override
    public String explain(ExplainDetail ... extraDetails) {
        List<Operation> operationList = this.operations.stream().map(o -> o).collect(Collectors.toList());
        return this.tableEnvironment.explainInternal(operationList, extraDetails);
    }

    @Override
    public TableResult execute() {
        try {
            TableResultInternal tableResultInternal = this.tableEnvironment.executeInternal(this.operations);
            return tableResultInternal;
        }
        finally {
            this.operations.clear();
        }
    }

    @Override
    @Experimental
    public CompiledPlan compilePlan() {
        return this.tableEnvironment.compilePlan(this.operations);
    }
}

