/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table;

import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.file.WriteMode;
import org.apache.flink.table.store.file.schema.SchemaManager;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.table.AppendOnlyFileStoreTable;
import org.apache.flink.table.store.table.ChangelogValueCountFileStoreTable;
import org.apache.flink.table.store.table.ChangelogWithKeyFileStoreTable;
import org.apache.flink.table.store.table.FileStoreTable;

public class FileStoreTableFactory {
    public static FileStoreTable create(Path path) {
        Configuration conf = new Configuration();
        conf.set((ConfigOption)CoreOptions.PATH, path.toString());
        return FileStoreTableFactory.create(conf);
    }

    public static FileStoreTable create(Configuration conf) {
        Path tablePath = CoreOptions.path(conf);
        TableSchema tableSchema = new SchemaManager(tablePath).latest().orElseThrow(() -> new IllegalArgumentException("Schema file not found in location " + tablePath + ". Please create table first."));
        return FileStoreTableFactory.create(tablePath, tableSchema, conf);
    }

    public static FileStoreTable create(Path tablePath, TableSchema tableSchema) {
        return FileStoreTableFactory.create(tablePath, tableSchema, new Configuration());
    }

    public static FileStoreTable create(Path tablePath, TableSchema tableSchema, Configuration dynamicOptions) {
        Configuration newOptions = Configuration.fromMap(tableSchema.options());
        dynamicOptions.toMap().forEach(newOptions::setString);
        newOptions.set((ConfigOption)CoreOptions.PATH, tablePath.toString());
        tableSchema = tableSchema.copy(newOptions.toMap());
        SchemaManager schemaManager = new SchemaManager(tablePath);
        if (newOptions.get(CoreOptions.WRITE_MODE) == WriteMode.APPEND_ONLY) {
            return new AppendOnlyFileStoreTable(tablePath, schemaManager, tableSchema);
        }
        if (tableSchema.primaryKeys().isEmpty()) {
            return new ChangelogValueCountFileStoreTable(tablePath, schemaManager, tableSchema);
        }
        return new ChangelogWithKeyFileStoreTable(tablePath, schemaManager, tableSchema);
    }
}

