/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.committer;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.sink2.Committer;
import org.apache.flink.connector.file.sink.FileSinkCommittable;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketWriter;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class FileCommitter
implements Committer<FileSinkCommittable> {
    private static final Logger LOG = LoggerFactory.getLogger(FileCommitter.class);
    private final BucketWriter<?, ?> bucketWriter;

    public FileCommitter(BucketWriter<?, ?> bucketWriter) {
        this.bucketWriter = Preconditions.checkNotNull(bucketWriter);
    }

    @Override
    public void commit(Collection<Committer.CommitRequest<FileSinkCommittable>> requests) throws IOException, InterruptedException {
        for (Committer.CommitRequest<FileSinkCommittable> request : requests) {
            FileSinkCommittable committable = request.getCommittable();
            if (committable.hasPendingFile()) {
                this.bucketWriter.recoverPendingFile(committable.getPendingFile()).commitAfterRecovery();
            }
            if (committable.hasInProgressFileToCleanup()) {
                this.bucketWriter.cleanupInProgressFileRecoverable(committable.getInProgressFileToCleanup());
            }
            if (!committable.hasCompactedFileToCleanup()) continue;
            Path committedFileToCleanup = committable.getCompactedFileToCleanup();
            try {
                committedFileToCleanup.getFileSystem().delete(committedFileToCleanup, false);
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Failed to cleanup a compacted file, the file will be remained and should not be visible: {}", (Object)committedFileToCleanup, (Object)e);
            }
        }
    }

    @Override
    public void close() throws Exception {
    }
}

