/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.plugin;

import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginConfig {
    private static final Logger LOG = LoggerFactory.getLogger(PluginConfig.class);
    private final Optional<Path> pluginsPath;
    private final String[] alwaysParentFirstPatterns;

    private PluginConfig(Optional<Path> pluginsPath, String[] alwaysParentFirstPatterns) {
        this.pluginsPath = pluginsPath;
        this.alwaysParentFirstPatterns = alwaysParentFirstPatterns;
    }

    public Optional<Path> getPluginsPath() {
        return this.pluginsPath;
    }

    public String[] getAlwaysParentFirstPatterns() {
        return this.alwaysParentFirstPatterns;
    }

    public static PluginConfig fromConfiguration(Configuration configuration) {
        return new PluginConfig(PluginConfig.getPluginsDir().map(File::toPath), CoreOptions.getPluginParentFirstLoaderPatterns(configuration));
    }

    public static Optional<File> getPluginsDir() {
        String pluginsDir = System.getenv().getOrDefault("FLINK_PLUGINS_DIR", "plugins");
        File pluginsDirFile = new File(pluginsDir);
        if (!pluginsDirFile.isDirectory()) {
            LOG.warn("The plugins directory [{}] does not exist.", (Object)pluginsDirFile);
            return Optional.empty();
        }
        return Optional.of(pluginsDirFile);
    }
}

