/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.Serializable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.util.Preconditions;

public final class ResultPartitionID
implements Serializable {
    private static final long serialVersionUID = -902516386203787826L;
    private final IntermediateResultPartitionID partitionId;
    private final ExecutionAttemptID producerId;

    @VisibleForTesting
    public ResultPartitionID() {
        this(new IntermediateResultPartitionID(), new ExecutionAttemptID());
    }

    public ResultPartitionID(IntermediateResultPartitionID partitionId, ExecutionAttemptID producerId) {
        this.partitionId = Preconditions.checkNotNull(partitionId);
        this.producerId = Preconditions.checkNotNull(producerId);
    }

    public IntermediateResultPartitionID getPartitionId() {
        return this.partitionId;
    }

    public ExecutionAttemptID getProducerId() {
        return this.producerId;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == ResultPartitionID.class) {
            ResultPartitionID o = (ResultPartitionID)obj;
            return o.getPartitionId().equals(this.partitionId) && o.getProducerId().equals(this.producerId);
        }
        return false;
    }

    public int hashCode() {
        return this.partitionId.hashCode() ^ this.producerId.hashCode();
    }

    public String toString() {
        return this.partitionId.toString() + "@" + this.producerId.toString();
    }
}

