/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.taskmanager;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.rest.messages.ResourceProfileInfo;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.json.ResourceIDDeserializer;
import org.apache.flink.runtime.rest.messages.json.ResourceIDSerializer;
import org.apache.flink.runtime.taskexecutor.TaskExecutorMemoryConfiguration;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.util.Preconditions;

public class TaskManagerInfo
implements ResponseBody,
Serializable {
    public static final String FIELD_NAME_RESOURCE_ID = "id";
    public static final String FIELD_NAME_ADDRESS = "path";
    public static final String FIELD_NAME_DATA_PORT = "dataPort";
    public static final String FIELD_NAME_JMX_PORT = "jmxPort";
    public static final String FIELD_NAME_LAST_HEARTBEAT = "timeSinceLastHeartbeat";
    public static final String FIELD_NAME_NUMBER_SLOTS = "slotsNumber";
    public static final String FIELD_NAME_NUMBER_AVAILABLE_SLOTS = "freeSlots";
    public static final String FIELD_NAME_TOTAL_RESOURCE = "totalResource";
    public static final String FIELD_NAME_AVAILABLE_RESOURCE = "freeResource";
    public static final String FIELD_NAME_HARDWARE = "hardware";
    public static final String FIELD_NAME_MEMORY = "memoryConfiguration";
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    @JsonSerialize(using=ResourceIDSerializer.class)
    private final ResourceID resourceId;
    @JsonProperty(value="path")
    private final String address;
    @JsonProperty(value="dataPort")
    private final int dataPort;
    @JsonProperty(value="jmxPort")
    private final int jmxPort;
    @JsonProperty(value="timeSinceLastHeartbeat")
    private final long lastHeartbeat;
    @JsonProperty(value="slotsNumber")
    private final int numberSlots;
    @JsonProperty(value="freeSlots")
    private final int numberAvailableSlots;
    @JsonProperty(value="totalResource")
    private final ResourceProfileInfo totalResource;
    @JsonProperty(value="freeResource")
    private final ResourceProfileInfo freeResource;
    @JsonProperty(value="hardware")
    private final HardwareDescription hardwareDescription;
    @JsonProperty(value="memoryConfiguration")
    private final TaskExecutorMemoryConfiguration memoryConfiguration;

    @JsonCreator
    public TaskManagerInfo(@JsonDeserialize(using=ResourceIDDeserializer.class) @JsonProperty(value="id") ResourceID resourceId, @JsonProperty(value="path") String address, @JsonProperty(value="dataPort") int dataPort, @JsonProperty(value="jmxPort") int jmxPort, @JsonProperty(value="timeSinceLastHeartbeat") long lastHeartbeat, @JsonProperty(value="slotsNumber") int numberSlots, @JsonProperty(value="freeSlots") int numberAvailableSlots, @JsonProperty(value="totalResource") ResourceProfileInfo totalResource, @JsonProperty(value="freeResource") ResourceProfileInfo freeResource, @JsonProperty(value="hardware") HardwareDescription hardwareDescription, @JsonProperty(value="memoryConfiguration") TaskExecutorMemoryConfiguration memoryConfiguration) {
        this.resourceId = Preconditions.checkNotNull(resourceId);
        this.address = Preconditions.checkNotNull(address);
        this.dataPort = dataPort;
        this.jmxPort = jmxPort;
        this.lastHeartbeat = lastHeartbeat;
        this.numberSlots = numberSlots;
        this.numberAvailableSlots = numberAvailableSlots;
        this.totalResource = totalResource;
        this.freeResource = freeResource;
        this.hardwareDescription = Preconditions.checkNotNull(hardwareDescription);
        this.memoryConfiguration = Preconditions.checkNotNull(memoryConfiguration);
    }

    public TaskManagerInfo(ResourceID resourceId, String address, int dataPort, int jmxPort, long lastHeartbeat, int numberSlots, int numberAvailableSlots, ResourceProfile totalResource, ResourceProfile freeResource, HardwareDescription hardwareDescription, TaskExecutorMemoryConfiguration memoryConfiguration) {
        this(resourceId, address, dataPort, jmxPort, lastHeartbeat, numberSlots, numberAvailableSlots, ResourceProfileInfo.fromResrouceProfile(totalResource), ResourceProfileInfo.fromResrouceProfile(freeResource), hardwareDescription, memoryConfiguration);
    }

    @JsonIgnore
    public ResourceID getResourceId() {
        return this.resourceId;
    }

    @JsonIgnore
    public String getAddress() {
        return this.address;
    }

    @JsonIgnore
    public int getDataPort() {
        return this.dataPort;
    }

    @JsonIgnore
    public int getJmxPort() {
        return this.jmxPort;
    }

    @JsonIgnore
    public long getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    @JsonIgnore
    public int getNumberSlots() {
        return this.numberSlots;
    }

    @JsonIgnore
    public int getNumberAvailableSlots() {
        return this.numberAvailableSlots;
    }

    @JsonIgnore
    public ResourceProfileInfo getTotalResource() {
        return this.totalResource;
    }

    @JsonIgnore
    public ResourceProfileInfo getFreeResource() {
        return this.freeResource;
    }

    @JsonIgnore
    public HardwareDescription getHardwareDescription() {
        return this.hardwareDescription;
    }

    @JsonIgnore
    public TaskExecutorMemoryConfiguration getMemoryConfiguration() {
        return this.memoryConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskManagerInfo that = (TaskManagerInfo)o;
        return this.dataPort == that.dataPort && this.jmxPort == that.jmxPort && this.lastHeartbeat == that.lastHeartbeat && this.numberSlots == that.numberSlots && this.numberAvailableSlots == that.numberAvailableSlots && Objects.equals(this.totalResource, that.totalResource) && Objects.equals(this.freeResource, that.freeResource) && Objects.equals(this.resourceId, that.resourceId) && Objects.equals(this.address, that.address) && Objects.equals(this.hardwareDescription, that.hardwareDescription) && Objects.equals(this.memoryConfiguration, that.memoryConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.resourceId, this.address, this.dataPort, this.jmxPort, this.lastHeartbeat, this.numberSlots, this.numberAvailableSlots, this.totalResource, this.freeResource, this.hardwareDescription, this.memoryConfiguration);
    }
}

