/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.io.FileWriter;
import org.apache.flink.table.store.file.utils.FileUtils;
import org.apache.flink.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SingleFileWriter<T, R>
implements FileWriter<T, R> {
    private static final Logger LOG = LoggerFactory.getLogger(SingleFileWriter.class);
    protected final Path path;
    private final Function<T, RowData> converter;
    private final BulkWriter<RowData> writer;
    private FSDataOutputStream out;
    private long recordCount;
    private long length;
    protected boolean closed;

    public SingleFileWriter(BulkWriter.Factory<RowData> factory, Path path, Function<T, RowData> converter) {
        this.path = path;
        this.converter = converter;
        try {
            FileSystem fs = path.getFileSystem();
            this.out = fs.create(path, FileSystem.WriteMode.NO_OVERWRITE);
            this.writer = factory.create(this.out);
        }
        catch (IOException e) {
            LOG.warn("Failed to open the bulk writer, closing the output stream and throw the error.", (Throwable)e);
            if (this.out != null) {
                this.abort();
            }
            throw new UncheckedIOException(e);
        }
        this.recordCount = 0L;
        this.length = 0L;
        this.closed = false;
    }

    public Path path() {
        return this.path;
    }

    @Override
    public void write(T record) throws IOException {
        this.writeImpl(record);
    }

    protected RowData writeImpl(T record) throws IOException {
        if (this.closed) {
            throw new RuntimeException("Writer has already closed!");
        }
        try {
            RowData rowData = this.converter.apply(record);
            this.writer.addElement((Object)rowData);
            ++this.recordCount;
            return rowData;
        }
        catch (Throwable e) {
            LOG.warn("Exception occurs when writing file " + this.path + ". Cleaning up.", e);
            this.abort();
            throw e;
        }
    }

    @Override
    public long recordCount() {
        return this.recordCount;
    }

    @Override
    public long length() throws IOException {
        if (this.closed) {
            return this.length;
        }
        return this.out.getPos();
    }

    @Override
    public void abort() {
        IOUtils.closeQuietly((AutoCloseable)this.out);
        FileUtils.deleteOrWarn(this.path);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closing file " + this.path);
        }
        try {
            this.writer.flush();
            this.writer.finish();
            this.out.flush();
            this.length = this.out.getPos();
            this.out.close();
        }
        catch (IOException e) {
            LOG.warn("Exception occurs when closing file " + this.path + ". Cleaning up.", (Throwable)e);
            this.abort();
            throw e;
        }
        finally {
            this.closed = true;
        }
    }
}

