/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.vector.reader;

import java.io.IOException;
import org.apache.flink.table.data.vector.writable.WritableIntVector;
import org.apache.flink.table.data.vector.writable.WritableShortVector;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.vector.reader.AbstractColumnReader;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.ColumnDescriptor;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.page.PageReader;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.PrimitiveType;

public class ShortColumnReader
extends AbstractColumnReader<WritableShortVector> {
    public ShortColumnReader(ColumnDescriptor descriptor, PageReader pageReader) throws IOException {
        super(descriptor, pageReader);
        this.checkTypeName(PrimitiveType.PrimitiveTypeName.INT32);
    }

    @Override
    protected void readBatch(int rowId, int num, WritableShortVector column) {
        int left = num;
        while (left > 0) {
            if (this.runLenDecoder.currentCount == 0) {
                this.runLenDecoder.readNextGroup();
            }
            int n = Math.min(left, this.runLenDecoder.currentCount);
            switch (this.runLenDecoder.mode) {
                case RLE: {
                    int i;
                    if (this.runLenDecoder.currentValue == this.maxDefLevel) {
                        for (i = 0; i < n; ++i) {
                            column.setShort(rowId + i, (short)this.readDataBuffer(4).getInt());
                        }
                        break;
                    }
                    column.setNulls(rowId, n);
                    break;
                }
                case PACKED: {
                    int i;
                    for (i = 0; i < n; ++i) {
                        if (this.runLenDecoder.currentBuffer[this.runLenDecoder.currentBufferIdx++] == this.maxDefLevel) {
                            column.setShort(rowId + i, (short)this.readDataBuffer(4).getInt());
                            continue;
                        }
                        column.setNullAt(rowId + i);
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.runLenDecoder.currentCount -= n;
        }
    }

    @Override
    protected void readBatchFromDictionaryIds(int rowId, int num, WritableShortVector column, WritableIntVector dictionaryIds) {
        for (int i = rowId; i < rowId + num; ++i) {
            if (column.isNullAt(i)) continue;
            column.setShort(i, (short)this.dictionary.decodeToInt(dictionaryIds.getInt(i)));
        }
    }
}

