/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.system;

import org.apache.flink.core.fs.Path;
import org.apache.flink.table.store.table.FileStoreTableFactory;
import org.apache.flink.table.store.table.Table;
import org.apache.flink.table.store.table.system.AuditLogTable;
import org.apache.flink.table.store.table.system.OptionsTable;
import org.apache.flink.table.store.table.system.SchemasTable;
import org.apache.flink.table.store.table.system.SnapshotsTable;

public class SystemTableLoader {
    public static Table load(String type, Path location) {
        switch (type.toLowerCase()) {
            case "snapshots": {
                return new SnapshotsTable(location);
            }
            case "options": {
                return new OptionsTable(location);
            }
            case "schemas": {
                return new SchemasTable(location);
            }
            case "audit_log": {
                return new AuditLogTable(FileStoreTableFactory.create(location));
            }
        }
        throw new UnsupportedOperationException("Unsupported system table type: " + type);
    }
}

