/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.hive;

import org.apache.flink.table.store.CatalogOptions;
import org.apache.flink.table.store.file.catalog.Catalog;
import org.apache.flink.table.store.file.catalog.CatalogFactory;
import org.apache.flink.table.store.hive.HiveCatalog;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.conf.HiveConf;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;

public class HiveCatalogFactory
implements CatalogFactory {
    private static final String IDENTIFIER = "hive";

    public String identifier() {
        return IDENTIFIER;
    }

    public Catalog create(String warehouse, org.apache.flink.configuration.Configuration options) {
        String uri = (String)Preconditions.checkNotNull((Object)options.get(CatalogOptions.URI), (String)(CatalogOptions.URI.key() + " must be set for table store " + IDENTIFIER + " catalog"));
        Configuration hadoopConfig = new Configuration();
        options.toMap().forEach((arg_0, arg_1) -> ((Configuration)hadoopConfig).set(arg_0, arg_1));
        hadoopConfig.set(HiveConf.ConfVars.METASTOREURIS.varname, uri);
        hadoopConfig.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, warehouse);
        return new HiveCatalog(hadoopConfig);
    }
}

