/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.ByteArrayOutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import org.apache.geronimo.mail.util.ASCIIUtil;
import org.apache.geronimo.mail.util.RFC2231Encoder;
import org.apache.geronimo.mail.util.SessionUtil;

public class ParameterList {
    private static final String MIME_ENCODEPARAMETERS = "mail.mime.encodeparameters";
    private static final String MIME_DECODEPARAMETERS = "mail.mime.decodeparameters";
    private static final String MIME_DECODEPARAMETERS_STRICT = "mail.mime.decodeparameters.strict";
    private static final int HEADER_SIZE_LIMIT = 76;
    private final Map<String, ParameterValue> _parameters = new HashMap<String, ParameterValue>();
    private final Map<MultiSegmentEntry, ParameterValue> _multiSegmentParameters = new TreeMap<MultiSegmentEntry, ParameterValue>();
    private boolean encodeParameters = false;
    private boolean decodeParameters = false;
    private boolean decodeParametersStrict = false;

    public ParameterList() {
        this.getInitialProperties();
    }

    public ParameterList(String list) throws ParseException {
        HeaderTokenizer.Token token;
        this.getInitialProperties();
        HeaderTokenizer tokenizer = new HeaderTokenizer(list, "()<>@,;:\\\"\t []/?=");
        while ((token = tokenizer.next()).getType() != -4) {
            if (token.getType() == 59) {
                token = tokenizer.next();
                if (token.getType() == -4) break;
                if (token.getType() != -1) {
                    throw new ParseException("Invalid parameter name: " + token.getValue());
                }
                String name = token.getValue().toLowerCase();
                token = tokenizer.next();
                if (token.getType() != 61) {
                    throw new ParseException("Missing '='");
                }
                token = tokenizer.next();
                if (token.getType() != -1 && token.getType() != -2) {
                    throw new ParseException("Invalid parameter value: " + token.getValue());
                }
                String value = token.getValue();
                String decodedValue = null;
                if (this.decodeParameters && name.endsWith("*") && !ParameterList.isMultiSegmentName(name)) {
                    block9: {
                        name = name.substring(0, name.length() - 1);
                        RFC2231Encoder decoder = new RFC2231Encoder("()<>@,;:\\\"\t []/?=");
                        try {
                            decodedValue = decoder.decode(value);
                        }
                        catch (Exception e) {
                            if (!this.decodeParametersStrict) break block9;
                            throw new ParseException("Invalid RFC2231 encoded parameter");
                        }
                    }
                    this._parameters.put(name, new ParameterValue(name, decodedValue, value));
                    continue;
                }
                if (ParameterList.isMultiSegmentName(name)) {
                    this._multiSegmentParameters.put(new MultiSegmentEntry(name), new ParameterValue(name, value));
                    continue;
                }
                this._parameters.put(name, new ParameterValue(name, value));
                continue;
            }
            throw new ParseException("Missing ';'");
        }
        this.combineSegments();
    }

    private static boolean isMultiSegmentName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        int firstAsterixIndex = name.indexOf(42);
        if (firstAsterixIndex < 0) {
            return false;
        }
        if (firstAsterixIndex == name.length() - 1) {
            return false;
        }
        String restOfname = name.substring(firstAsterixIndex + 1);
        return Character.isDigit(restOfname.charAt(0));
    }

    public void combineSegments() {
        if (this._multiSegmentParameters.size() > 0) {
            RFC2231Encoder decoder = new RFC2231Encoder("()<>@,;:\\\"\t []/?=");
            String lastName = null;
            int lastSegmentNumber = -1;
            StringBuilder segmentValue = new StringBuilder();
            for (Map.Entry<MultiSegmentEntry, ParameterValue> entry : this._multiSegmentParameters.entrySet()) {
                MultiSegmentEntry currentMEntry = entry.getKey();
                if (lastName == null) {
                    lastName = currentMEntry.name;
                } else if (!lastName.equals(currentMEntry.name)) {
                    this._parameters.put(lastName, new ParameterValue(lastName, segmentValue.toString()));
                    segmentValue.setLength(0);
                    lastName = currentMEntry.name;
                }
                if (lastSegmentNumber == -1 ? (lastSegmentNumber = currentMEntry.range) != 0 : lastSegmentNumber + 1 != currentMEntry.range) {
                    // empty if block
                }
                if (currentMEntry.encoded) {
                    try {
                        segmentValue.append(decoder.decode(entry.getValue().value));
                    }
                    catch (Exception e) {
                        segmentValue.append(entry.getValue().value);
                    }
                    continue;
                }
                segmentValue.append(entry.getValue().value);
            }
            this._parameters.put(lastName, new ParameterValue(lastName, segmentValue.toString()));
        }
    }

    private void getInitialProperties() {
        this.decodeParameters = SessionUtil.getBooleanProperty(MIME_DECODEPARAMETERS, true);
        this.decodeParametersStrict = SessionUtil.getBooleanProperty(MIME_DECODEPARAMETERS_STRICT, false);
        this.encodeParameters = SessionUtil.getBooleanProperty(MIME_ENCODEPARAMETERS, true);
    }

    public int size() {
        return this._parameters.size();
    }

    public String get(String name) {
        ParameterValue value = this._parameters.get(name.toLowerCase());
        if (value != null) {
            return value.value;
        }
        return null;
    }

    public void set(String name, String value) {
        if (ParameterList.isMultiSegmentName(name = name.toLowerCase())) {
            this._multiSegmentParameters.put(new MultiSegmentEntry(name), new ParameterValue(name, value));
        } else {
            this._parameters.put(name, new ParameterValue(name, value));
        }
    }

    public void set(String name, String value, String charset) {
        name = name.toLowerCase();
        if (this.encodeParameters && !ASCIIUtil.isAscii(value)) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                RFC2231Encoder encoder = new RFC2231Encoder("()<>@,;:\\\"\t []/?=");
                byte[] valueBytes = value.getBytes(MimeUtility.javaCharset(charset));
                out.write(charset.getBytes("ISO8859-1"));
                out.write(39);
                out.write(39);
                encoder.encode(valueBytes, 0, valueBytes.length, out);
                if (ParameterList.isMultiSegmentName(name)) {
                    this._multiSegmentParameters.put(new MultiSegmentEntry(name), new ParameterValue(name, value, new String(out.toByteArray(), "ISO8859-1")));
                } else {
                    this._parameters.put(name, new ParameterValue(name, value, new String(out.toByteArray(), "ISO8859-1")));
                }
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ParameterList.isMultiSegmentName(name)) {
            this._multiSegmentParameters.put(new MultiSegmentEntry(name), new ParameterValue(name, value));
        } else {
            this._parameters.put(name, new ParameterValue(name, value));
        }
    }

    public void remove(String name) {
        this._parameters.remove(name);
    }

    public Enumeration<String> getNames() {
        return Collections.enumeration(this._parameters.keySet());
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int used) {
        StringBuffer stringValue = new StringBuffer();
        for (ParameterValue parm : this._parameters.values()) {
            String name = parm.getEncodedName();
            String value = parm.toString();
            stringValue.append("; ");
            if ((used += 2) + name.length() + value.length() + 1 > 76) {
                stringValue.append("\r\n\t");
                used = 8;
            }
            stringValue.append(name);
            stringValue.append("=");
            if ((used += name.length() + 1) + value.length() > 76) {
                String foldedValue = MimeUtility.fold(used, value);
                stringValue.append(foldedValue);
                int lastLineBreak = foldedValue.lastIndexOf(10);
                if (lastLineBreak != -1) {
                    used = foldedValue.length() - lastLineBreak + 1;
                    continue;
                }
                used += foldedValue.length();
                continue;
            }
            stringValue.append(value);
            used += value.length();
        }
        return stringValue.toString();
    }

    static class MultiSegmentEntry
    implements Comparable<MultiSegmentEntry> {
        final String original;
        final String normalized;
        final String name;
        final int range;
        final boolean encoded;

        public MultiSegmentEntry(String original) {
            this.original = original;
            int firstAsterixIndex1 = original.indexOf(42);
            this.encoded = original.endsWith("*");
            int endIndex1 = this.encoded ? original.length() - 1 : original.length();
            this.name = original.substring(0, firstAsterixIndex1);
            this.range = Integer.parseInt(original.substring(firstAsterixIndex1 + 1, endIndex1));
            this.normalized = original.substring(0, endIndex1);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.normalized == null ? 0 : this.normalized.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MultiSegmentEntry other = (MultiSegmentEntry)obj;
            return !(this.normalized == null ? other.normalized != null : !this.normalized.equals(other.normalized));
        }

        @Override
        public int compareTo(MultiSegmentEntry o) {
            if (this.equals(o)) {
                return 0;
            }
            if (this.name.equals(o.name)) {
                return this.range > o.range ? 1 : -1;
            }
            return this.name.compareTo(o.name);
        }

        public String toString() {
            return "MultiSegmentEntry\n[original=" + this.original + ", name=" + this.name + ", range=" + this.range + "]\n";
        }
    }

    class ParameterValue {
        public String name;
        public String value;
        public String encodedValue;

        public ParameterValue(String name, String value) {
            this.name = name;
            this.value = value;
            this.encodedValue = null;
        }

        public ParameterValue(String name, String value, String encodedValue) {
            this.name = name;
            this.value = value;
            this.encodedValue = encodedValue;
        }

        public String toString() {
            if (this.encodedValue != null) {
                return MimeUtility.quote(this.encodedValue, "()<>@,;:\\\"\t []/?=");
            }
            return MimeUtility.quote(this.value, "()<>@,;:\\\"\t []/?=");
        }

        public String getEncodedName() {
            if (this.encodedValue != null) {
                return this.name + "*";
            }
            return this.name;
        }
    }
}

