/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.core.MethodClassKey;
import org.springframework.lang.Nullable;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringValueResolver;

public abstract class AbstractFallbackTransactionAttributeSource
implements TransactionAttributeSource,
EmbeddedValueResolverAware {
    private static final TransactionAttribute NULL_TRANSACTION_ATTRIBUTE = new DefaultTransactionAttribute(){

        @Override
        public String toString() {
            return "null";
        }
    };
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Nullable
    private transient StringValueResolver embeddedValueResolver;
    private final Map<Object, TransactionAttribute> attributeCache = new ConcurrentHashMap<Object, TransactionAttribute>(1024);

    @Override
    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    @Override
    public boolean hasTransactionAttribute(Method method, @Nullable Class<?> targetClass) {
        return this.getTransactionAttribute(method, targetClass, false) != null;
    }

    @Override
    @Nullable
    public TransactionAttribute getTransactionAttribute(Method method, @Nullable Class<?> targetClass) {
        return this.getTransactionAttribute(method, targetClass, true);
    }

    @Nullable
    private TransactionAttribute getTransactionAttribute(Method method, @Nullable Class<?> targetClass, boolean cacheNull) {
        if (ReflectionUtils.isObjectMethod(method)) {
            return null;
        }
        Object cacheKey = this.getCacheKey(method, targetClass);
        TransactionAttribute cached = this.attributeCache.get(cacheKey);
        if (cached != null) {
            return cached != NULL_TRANSACTION_ATTRIBUTE ? cached : null;
        }
        TransactionAttribute txAttr = this.computeTransactionAttribute(method, targetClass);
        if (txAttr != null) {
            String methodIdentification = ClassUtils.getQualifiedMethodName(method, targetClass);
            if (txAttr instanceof DefaultTransactionAttribute) {
                DefaultTransactionAttribute dta = (DefaultTransactionAttribute)txAttr;
                dta.setDescriptor(methodIdentification);
                dta.resolveAttributeStrings(this.embeddedValueResolver);
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Adding transactional method '" + methodIdentification + "' with attribute: " + String.valueOf(txAttr));
            }
            this.attributeCache.put(cacheKey, txAttr);
        } else if (cacheNull) {
            this.attributeCache.put(cacheKey, NULL_TRANSACTION_ATTRIBUTE);
        }
        return txAttr;
    }

    protected Object getCacheKey(Method method, @Nullable Class<?> targetClass) {
        return new MethodClassKey(method, targetClass);
    }

    @Nullable
    protected TransactionAttribute computeTransactionAttribute(Method method, @Nullable Class<?> targetClass) {
        if (this.allowPublicMethodsOnly() && !Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        if (method.getDeclaringClass() == BeanFactoryAware.class) {
            return null;
        }
        Method specificMethod = AopUtils.getMostSpecificMethod(method, targetClass);
        TransactionAttribute txAttr = this.findTransactionAttribute(specificMethod);
        if (txAttr != null) {
            return txAttr;
        }
        txAttr = this.findTransactionAttribute(specificMethod.getDeclaringClass());
        if (txAttr != null && ClassUtils.isUserLevelMethod(method)) {
            return txAttr;
        }
        if (specificMethod != method) {
            txAttr = this.findTransactionAttribute(method);
            if (txAttr != null) {
                return txAttr;
            }
            txAttr = this.findTransactionAttribute(method.getDeclaringClass());
            if (txAttr != null && ClassUtils.isUserLevelMethod(method)) {
                return txAttr;
            }
        }
        return null;
    }

    @Nullable
    protected abstract TransactionAttribute findTransactionAttribute(Class<?> var1);

    @Nullable
    protected abstract TransactionAttribute findTransactionAttribute(Method var1);

    protected boolean allowPublicMethodsOnly() {
        return false;
    }
}

