/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.sc.transformers;

import java.util.List;
import java.util.stream.Collectors;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.transform.sc.transformers.StaticCompilationTransformer;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;

class ListExpressionTransformer {
    private final StaticCompilationTransformer scTransformer;

    ListExpressionTransformer(StaticCompilationTransformer scTransformer) {
        this.scTransformer = scTransformer;
    }

    Expression transformListExpression(ListExpression le) {
        MethodNode mn = (MethodNode)le.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
        if (mn instanceof ConstructorNode) {
            List<Expression> elements = le.getExpressions().stream().map(this.scTransformer::transform).collect(Collectors.toList());
            if (mn.getDeclaringClass().isArray()) {
                ArrayExpression ae = new ArrayExpression(mn.getDeclaringClass().getComponentType(), elements);
                ae.setSourcePosition(le);
                return ae;
            }
            ConstructorCallExpression cce = new ConstructorCallExpression(mn.getDeclaringClass(), new ArgumentListExpression(elements));
            cce.putNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET, mn);
            cce.setSourcePosition(le);
            return cce;
        }
        return this.scTransformer.superTransform(le);
    }
}

