/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest;

import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.environment.Environment;
import org.apache.guacamole.properties.GuacamoleProperty;
import org.apache.guacamole.properties.LongGuacamoleProperty;
import org.apache.guacamole.rest.APIException;
import org.apache.guacamole.rest.LimitedRequestInputStream;
import org.apache.guacamole.rest.RequestSizeFilter;

@Singleton
@Provider
public class RequestSizeFilter
implements ContainerRequestFilter {
    private static final long DEFAULT_MAX_REQUEST_SIZE = 0x200000L;
    private final LongGuacamoleProperty API_MAX_REQUEST_SIZE = new /* Unavailable Anonymous Inner Class!! */;
    @Inject
    private Environment environment;
    @Context
    private ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext context) throws IOException {
        long maxRequestSize;
        try {
            maxRequestSize = (Long)this.environment.getProperty((GuacamoleProperty)this.API_MAX_REQUEST_SIZE, (Object)0x200000L);
        }
        catch (GuacamoleException e) {
            throw new APIException(e);
        }
        if (maxRequestSize == 0L || this.resourceInfo.getResourceMethod().isAnnotationPresent(DoNotLimit.class)) {
            return;
        }
        InputStream stream = context.getEntityStream();
        if (stream != null) {
            context.setEntityStream((InputStream)new LimitedRequestInputStream(stream, maxRequestSize));
        }
    }
}

