/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientBeforeNodeStart;
import org.apache.ignite.internal.client.GridClientCompute;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientDisconnectedException;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.commandline.CloseableCliCommandInvoker;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.BeforeNodeStartCommand;
import org.apache.ignite.internal.management.api.Command;
import org.apache.ignite.internal.management.api.CommandInvoker;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteBiTuple;

@Deprecated
public class CliCommandInvoker<A extends IgniteDataTransferObject>
extends CommandInvoker<A>
implements CloseableCliCommandInvoker {
    private final GridClientConfiguration clientCfg;
    private GridClient client;

    public CliCommandInvoker(Command<A, ?> cmd, A arg, GridClientConfiguration clientCfg) {
        super(cmd, arg, null);
        this.clientCfg = clientCfg;
    }

    @Override
    public String confirmationPrompt() {
        return this.cmd.confirmationPrompt(this.arg);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R invokeBeforeNodeStart(Consumer<String> printer) throws Exception {
        try (GridClientBeforeNodeStart client = CliCommandInvoker.startClientBeforeNodeStart(this.clientCfg);){
            Object object = ((BeforeNodeStartCommand)this.cmd).execute(client.beforeStartState(), this.arg, printer);
            return (R)object;
        }
        catch (GridClientDisconnectedException e) {
            throw new GridClientException(e.getCause());
        }
    }

    protected GridClientNode defaultNode() throws GridClientException {
        GridClientNode node;
        String cfgAddr = (String)this.clientCfg.getServers().iterator().next();
        String[] parts = cfgAddr.split(":");
        if ("127.0.0.1".equals(parts[0])) {
            InetAddress addr;
            try {
                addr = IgniteUtils.getLocalHost();
            }
            catch (IOException e) {
                throw new GridClientException("Can't get localhost name.", (Throwable)e);
            }
            if (addr.isLoopbackAddress()) {
                throw new GridClientException("Can't find localhost name.");
            }
            String origAddr = addr.getHostName() + ":" + parts[1];
            node = CliCommandInvoker.listHosts(this.client()).filter(tuple -> origAddr.equals(tuple.get2())).findFirst().map(IgniteBiTuple::get1).orElse(null);
            if (node == null) {
                node = CliCommandInvoker.listHostsByClientNode(this.client()).filter(tuple -> ((List)tuple.get2()).size() == 1 && cfgAddr.equals(((List)tuple.get2()).get(0))).findFirst().map(IgniteBiTuple::get1).orElse(null);
            }
        } else {
            node = CliCommandInvoker.listHosts(this.client()).filter(tuple -> cfgAddr.equals(tuple.get2())).findFirst().map(IgniteBiTuple::get1).orElse(null);
        }
        if (node == null) {
            node = CliCommandInvoker.balancedNode(this.client().compute());
        }
        return node;
    }

    protected GridClient client() throws GridClientException {
        if (this.client != null && this.client.connected()) {
            return this.client;
        }
        this.client = GridClientFactory.start((GridClientConfiguration)this.clientCfg);
        if (!this.client.connected()) {
            GridClientException lastErr = this.client.checkLastError();
            try {
                this.client.close();
            }
            catch (Throwable e) {
                lastErr.addSuppressed(e);
            }
            throw lastErr;
        }
        return this.client;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    private static GridClientBeforeNodeStart startClientBeforeNodeStart(GridClientConfiguration clientCfg) throws Exception {
        GridClientBeforeNodeStart client = GridClientFactory.startBeforeNodeStart((GridClientConfiguration)clientCfg);
        if (!client.connected()) {
            GridClientException lastErr = client.checkLastError();
            try {
                client.close();
            }
            catch (Throwable e) {
                lastErr.addSuppressed(e);
            }
            throw lastErr;
        }
        return client;
    }

    private static Stream<IgniteBiTuple<GridClientNode, String>> listHosts(GridClient client) throws GridClientException {
        return client.compute().nodes(GridClientNode::connectable).stream().flatMap(node -> Stream.concat(node.tcpAddresses() == null ? Stream.empty() : node.tcpAddresses().stream(), node.tcpHostNames() == null ? Stream.empty() : node.tcpHostNames().stream()).map(addr -> new IgniteBiTuple(node, (Object)(addr + ":" + node.tcpPort()))));
    }

    private static Stream<IgniteBiTuple<GridClientNode, List<String>>> listHostsByClientNode(GridClient client) throws GridClientException {
        return client.compute().nodes(GridClientNode::connectable).stream().map(node -> new IgniteBiTuple(node, Stream.concat(node.tcpAddresses() == null ? Stream.empty() : node.tcpAddresses().stream(), node.tcpHostNames() == null ? Stream.empty() : node.tcpHostNames().stream()).map(addr -> addr + ":" + node.tcpPort()).collect(Collectors.toList())));
    }

    private static GridClientNode balancedNode(GridClientCompute compute) throws GridClientException {
        Collection nodes = compute.nodes(GridClientNode::connectable);
        if (F.isEmpty((Collection)nodes)) {
            throw new GridClientDisconnectedException("Connectable node not found", null);
        }
        return compute.balancer().balancedNode(nodes);
    }
}

